/*
 * Decompiled with CFR 0.152.
 */
package uk.binarycraft.journeymapdefaults.proxies;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.FileUtils;
import uk.binarycraft.journeymapdefaults.JourneyMapDefaults;
import uk.binarycraft.journeymapdefaults.proxies.CommonProxy;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        if (this.firstRunFileExists() && JourneyMapDefaults.onlyCreateConfigOnFirstRun) {
            return;
        }
        this.createDefaultJourneyMapConfigsIfRequired();
        this.copyFilesFromConfigDirToJourneyMapDir();
        this.createFirstRunFile();
    }

    private boolean firstRunFileExists() {
        Path firstRunFilePath = Paths.get(JourneyMapDefaults.instanceRootDirectory, JourneyMapDefaults.firstRunFile);
        File firstRunFile = new File(firstRunFilePath.toString());
        return firstRunFile.exists();
    }

    private void createFirstRunFile() {
        Path firstRunFilePath = Paths.get(JourneyMapDefaults.instanceRootDirectory, JourneyMapDefaults.firstRunFile);
        File firstRunFile = new File(firstRunFilePath.toString());
        try {
            firstRunFile.createNewFile();
        }
        catch (IOException ex) {
            System.out.println("Unable to create first run file. The reported error was " + ex.getMessage());
        }
    }

    private void createDefaultJourneyMapConfigsIfRequired() {
        this.createConfigDir();
        this.createCoreConfig();
        this.createFullMapConfig();
        this.createMiniMapConfig();
        this.createMiniMap2Config();
        this.createTopoConfig();
        this.createWayPointConfig();
        this.createWebMapConfig();
    }

    private void createConfigDir() {
        Path configDirPath = Paths.get(JourneyMapDefaults.journeyMapDefaultsConfigDirectory, new String[0]);
        System.out.println(configDirPath.toString());
        File configDir = new File(configDirPath.toString());
        if (configDir.exists()) {
            return;
        }
        configDir.mkdir();
    }

    private String getPath(String configFile) {
        return Paths.get(JourneyMapDefaults.journeyMapDefaultsConfigDirectory, configFile).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(File file, String contents) {
        if (file.exists()) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (IOException ex) {
            System.out.println("Unable to create default config file. The reported error was " + ex.getMessage());
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                System.out.println("Unable to close default config file. The reported error was " + ex.getMessage());
            }
        }
    }

    private void createCoreConfig() {
        File configFile = new File(this.getPath("journeymap.core.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"logLevel\": \"INFO\",\n  \"autoMapPoll\": \"2000\",\n  \"cacheAnimalsData\": \"3100\",\n  \"cacheMobsData\": \"3000\",\n  \"cachePlayerData\": \"1000\",\n  \"cachePlayersData\": \"2000\",\n  \"cacheVillagersData\": \"2200\",\n  \"announceMod\": \"false\",\n  \"checkUpdates\": \"false\",\n  \"recordCacheStats\": \"false\",\n  \"browserPoll\": \"2000\",\n  \"themeName\": \"OceanMonument\",\n  \"caveIgnoreGlass\": \"true\",\n  \"mapBathymetry\": \"false\",\n  \"mapTopography\": \"true\",\n  \"mapTransparency\": \"true\",\n  \"mapCaveLighting\": \"true\",\n  \"mapAntialiasing\": \"true\",\n  \"mapPlantShadows\": \"false\",\n  \"mapPlants\": \"false\",\n  \"mapCrops\": \"true\",\n  \"mapBlendGrass\": \"true\",\n  \"mapBlendFoliage\": \"true\",\n  \"mapBlendWater\": \"false\",\n  \"mapSurfaceAboveCaves\": \"true\",\n  \"renderDistanceCaveMax\": \"3\",\n  \"renderDistanceSurfaceMax\": \"7\",\n  \"renderDelay\": \"2\",\n  \"revealShape\": \"Circle\",\n  \"alwaysMapCaves\": \"false\",\n  \"alwaysMapSurface\": \"false\",\n  \"tileHighDisplayQuality\": \"true\",\n  \"maxAnimalsData\": \"32\",\n  \"maxMobsData\": \"32\",\n  \"maxPlayersData\": \"32\",\n  \"maxVillagersData\": \"32\",\n  \"hideSneakingEntities\": \"true\",\n  \"radarLateralDistance\": \"64\",\n  \"radarVerticalDistance\": \"16\",\n  \"tileRenderType\": \"1\",\n  \"mappingEnabled\": \"true\",\n  \"renderOverlayEventTypeName\": \"ALL\",\n  \"renderOverlayPreEvent\": \"true\",\n  \"optionsManagerViewed\": \"5.5.2\",\n  \"splashViewed\": \"5.5.2\",\n  \"gridSpecs\": {\n    \"day\": \"Squares,#808080,0.5,-1,-1\",\n    \"night\": \"Squares,#8080ff,0.3,-1,-1\",\n    \"underground\": \"Squares,#808080,0.3,-1,-1\"\n  },\n  \"colorPassive\": \"#bbbbbb\",\n  \"colorHostile\": \"#ff0000\",\n  \"colorPet\": \"#0077ff\",\n  \"colorVillager\": \"#88e188\",\n  \"colorPlayer\": \"#ffffff\",\n  \"colorSelf\": \"#0000ff\",\n  \"verboseColorPalette\": \"false\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createMiniMapConfig() {
        File configFile = new File(this.getPath("journeymap.minimap.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"enabled\": \"true\",\n  \"shape\": \"Circle\",\n  \"position\": \"TopRight\",\n  \"showDayNight\": \"true\",\n  \"info1Label\": \"FPS\",\n  \"info2Label\": \"GameTime\",\n  \"info3Label\": \"Location\",\n  \"info4Label\": \"Biome\",\n  \"sizePercent\": \"30\",\n  \"frameAlpha\": \"100\",\n  \"terrainAlpha\": \"100\",\n  \"orientation\": \"PlayerHeading\",\n  \"compassFontScale\": \"1\",\n  \"showCompass\": \"true\",\n  \"showReticle\": \"true\",\n  \"reticleOrientation\": \"Compass\",\n  \"active\": true,\n  \"playerDisplay\": \"LargeIcons\",\n  \"showPlayerHeading\": \"false\",\n  \"mobDisplay\": \"LargeIcons\",\n  \"showMobHeading\": \"false\",\n  \"showMobs\": \"true\",\n  \"showAnimals\": \"true\",\n  \"showVillagers\": \"true\",\n  \"showPets\": \"true\",\n  \"showPlayers\": \"true\",\n  \"fontScale\": \"1\",\n  \"showWaypointLabels\": \"true\",\n  \"locationFormatVerbose\": \"false\",\n  \"locationFormat\": \"xyz\",\n  \"showWaypoints\": \"true\",\n  \"showSelf\": \"true\",\n  \"showGrid\": \"true\",\n  \"showCaves\": \"true\",\n  \"showEntityNames\": \"true\",\n  \"preferredMapType\": \"day\",\n  \"zoomLevel\": \"0\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createMiniMap2Config() {
        File configFile = new File(this.getPath("journeymap.minimap2.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"enabled\": \"true\",\n  \"shape\": \"Circle\",\n  \"position\": \"TopRight\",\n  \"showDayNight\": \"true\",\n  \"info1Label\": \"FPS\",\n  \"info2Label\": \"GameTime\",\n  \"info3Label\": \"Location\",\n  \"info4Label\": \"Biome\",\n  \"sizePercent\": \"30\",\n  \"frameAlpha\": \"100\",\n  \"terrainAlpha\": \"100\",\n  \"orientation\": \"PlayerHeading\",\n  \"compassFontScale\": \"1\",\n  \"showCompass\": \"true\",\n  \"showReticle\": \"true\",\n  \"reticleOrientation\": \"Compass\",\n  \"active\": false,\n  \"playerDisplay\": \"SmallDots\",\n  \"showPlayerHeading\": \"false\",\n  \"mobDisplay\": \"SmallDots\",\n  \"showMobHeading\": \"false\",\n  \"showMobs\": \"true\",\n  \"showAnimals\": \"true\",\n  \"showVillagers\": \"true\",\n  \"showPets\": \"true\",\n  \"showPlayers\": \"true\",\n  \"fontScale\": \"1\",\n  \"showWaypointLabels\": \"true\",\n  \"locationFormatVerbose\": \"false\",\n  \"locationFormat\": \"xyz\",\n  \"showWaypoints\": \"true\",\n  \"showSelf\": \"true\",\n  \"showGrid\": \"true\",\n  \"showCaves\": \"true\",\n  \"showEntityNames\": \"true\",\n  \"preferredMapType\": \"day\",\n  \"zoomLevel\": \"0\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createTopoConfig() {
        File configFile = new File(this.getPath("journeymap.topo.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// For more information, go to: http://journeymap.info/Topographic\n{\n  \"showContour\": \"true\",\n  \"landContour\": \"#3F250B\",\n  \"waterContour\": \"#0000dd\",\n  \"land\": \"#010c02,#041105,#071609,#0a1b0c,#0d200f,#102513,#132a16,#162f19,#19341c,#1b3a20,#1e3f23,#214426,#24492a,#274e2d,#2a5330,#2d5834,#375f41,#41674d,#4b6e5a,#557567,#5f7c73,#698480,#738b8d,#7c929a,#8699a6,#90a1b3,#9aa8c0,#a4afcc,#aeb6d9,#b8bee6,#c2c5f2,#ccccff,#cccfff,#ccd2ff,#ccd6ff,#ccd9ff,#ccdcff,#ccdfff,#cce2ff,#cce5ff,#cce9ff,#ccecff,#ccefff,#ccf2ff,#ccf5ff,#ccf9ff,#ccfcff,#ccffff,#cfffff,#d2ffff,#d6ffff,#d9ffff,#dcffff,#dfffff,#e2ffff,#e5ffff,#e9ffff,#ecffff,#efffff,#f2ffff,#f5ffff,#f9ffff,#fcffff,#ffffff\",\n  \"water\": \"#000040,#02024e,#03035d,#05056b,#070779,#080887,#0a0a96,#0b0ba4,#1a1aaa,#2a2aaf,#3939b5,#4848bb,#5757c0,#6767c6,#7676cc,#8585d2,#9494d7,#a4a4dd,#b3b3e3,#c2c2e8,#d1d1ee,#d7d7f0,#ddddf2,#e2e2f4,#e8e8f6,#eeeef9,#f4f4fb,#f9f9ff,#f9f9ff,#f9f9ff,#f9f9ff,#f9f9ff\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createWayPointConfig() {
        File configFile = new File(this.getPath("journeymap.waypoint.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"managerEnabled\": \"true\",\n  \"beaconEnabled\": \"true\",\n  \"showTexture\": \"true\",\n  \"showStaticBeam\": \"false\",\n  \"showRotatingBeam\": \"false\",\n  \"showName\": \"true\",\n  \"showDistance\": \"true\",\n  \"autoHideLabel\": \"true\",\n  \"boldLabel\": \"false\",\n  \"fontScale\": \"2\",\n  \"textureSmall\": \"true\",\n  \"maxDistance\": \"0\",\n  \"minDistance\": \"4\",\n  \"createDeathpoints\": \"true\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createWebMapConfig() {
        File configFile = new File(this.getPath("journeymap.webmap.config"));
        this.createFile(configFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"enabled\": \"false\",\n  \"port\": \"8080\",\n  \"googleMapApiDomain\": \".com\",\n  \"showWaypoints\": \"true\",\n  \"showSelf\": \"true\",\n  \"showGrid\": \"true\",\n  \"showCaves\": \"true\",\n  \"showEntityNames\": \"true\",\n  \"preferredMapType\": \"day\",\n  \"zoomLevel\": \"0\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void createFullMapConfig() {
        File fullMapConfigFile = new File(this.getPath("journeymap.fullmap.config"));
        this.createFile(fullMapConfigFile, "// JourneyMap configuration file. Modify at your own risk!\n// To use in all worlds, place here: journeymap/config/5.5/\n// For more information, go to: http://journeymap.info/Options_Manager\n{\n  \"showKeys\": \"true\",\n  \"playerDisplay\": \"LargeIcons\",\n  \"showPlayerHeading\": \"false\",\n  \"mobDisplay\": \"LargeIcons\",\n  \"showMobHeading\": \"false\",\n  \"showMobs\": \"true\",\n  \"showAnimals\": \"true\",\n  \"showVillagers\": \"true\",\n  \"showPets\": \"true\",\n  \"showPlayers\": \"true\",\n  \"fontScale\": \"1\",\n  \"showWaypointLabels\": \"true\",\n  \"locationFormatVerbose\": \"false\",\n  \"locationFormat\": \"xyz\",\n  \"showWaypoints\": \"true\",\n  \"showSelf\": \"true\",\n  \"showGrid\": \"true\",\n  \"showCaves\": \"true\",\n  \"showEntityNames\": \"true\",\n  \"preferredMapType\": \"day\",\n  \"zoomLevel\": \"0\",\n  \"configVersion\": \"5.5.2\"\n}");
    }

    private void copyFilesFromConfigDirToJourneyMapDir() {
        File directory = new File(JourneyMapDefaults.journeyMapDefaultsConfigDirectory);
        File[] journeyMapConfigFiles = directory.listFiles();
        if (journeyMapConfigFiles == null) {
            return;
        }
        for (File file : journeyMapConfigFiles) {
            String destinationPath = Paths.get(JourneyMapDefaults.journeyMapConfigDir, file.getName()).toString();
            File destination = new File(destinationPath);
            try {
                FileUtils.copyFile((File)file, (File)destination);
            }
            catch (IOException ex) {
                System.out.println("Unable to copy " + file.getName() + ", the reported error was " + ex.getMessage());
            }
        }
    }
}

