/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui.interaction;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.common.WContainer;

@SideOnly(value=Side.CLIENT)
public class WInteraction {
    private final WGuiContainer<?> wGuiContainer;
    private final EntityPlayer entityPlayer;
    private final int mouseX;
    private final int mouseY;
    private boolean proceed = true;

    public WInteraction(@Nonnull WGuiContainer<?> wGuiContainer) {
        this(wGuiContainer, Mouse.getEventX() * wGuiContainer.field_146294_l / wGuiContainer.field_146297_k.field_71443_c, wGuiContainer.field_146295_m - Mouse.getEventY() * wGuiContainer.field_146295_m / wGuiContainer.field_146297_k.field_71440_d - 1);
    }

    public WInteraction(@Nonnull WGuiContainer<?> wGuiContainer, int mouseX, int mouseY) {
        this.wGuiContainer = wGuiContainer;
        this.entityPlayer = wGuiContainer.getEntityPlayer();
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Nonnull
    public final WGuiContainer<?> getWGuiContainer() {
        return this.wGuiContainer;
    }

    @Nonnull
    public final WContainer<?> getWContainer() {
        return this.wGuiContainer.getContainer();
    }

    @Nonnull
    public EntityPlayer getEntityPlayer() {
        return this.entityPlayer;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public boolean isHovering(@Nonnull WElement<?> wElement) {
        return this.mouseX >= wElement.getUsableX() && this.mouseY >= wElement.getUsableY() && this.mouseX < wElement.getUsableX() + wElement.getWidth() && this.mouseY < wElement.getUsableY() + wElement.getHeight();
    }

    public final void proceed() {
        this.proceed = true;
    }

    public final void notProceed() {
        this.proceed = false;
    }

    public final boolean shouldProceed() {
        return this.proceed;
    }
}

