/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.NBTUtils;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.AnyDamageMatcher;
import wanion.lib.common.matching.matcher.EmptyMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.NbtMatcher;
import wanion.lib.common.matching.matcher.OreDictMatcher;

public final class CraftTweakerHelper {
    public static final String NULL = "null";

    private CraftTweakerHelper() {
    }

    public static String MatcherToCtFormat(@Nonnull AbstractMatcher<?> matcher) {
        ItemStack itemStack = matcher.getStack();
        if (matcher instanceof EmptyMatcher) {
            return NULL;
        }
        if (matcher instanceof ItemStackMatcher) {
            StringBuilder formatBuilder = new StringBuilder().append('<');
            formatBuilder.append(itemStack.func_77973_b().getRegistryName());
            if (itemStack.func_77952_i() > 0) {
                formatBuilder.append(':').append(itemStack.func_77952_i());
            }
            formatBuilder.append('>');
            if (itemStack.func_190916_E() > 1) {
                formatBuilder.append(" * ").append(itemStack.func_190916_E());
            }
            return formatBuilder.toString();
        }
        if (matcher instanceof AnyDamageMatcher) {
            StringBuilder formatBuilder = new StringBuilder().append('<');
            formatBuilder.append(itemStack.func_77973_b().getRegistryName()).append(":*>");
            if (itemStack.func_190916_E() > 1) {
                formatBuilder.append(" * ").append(itemStack.func_190916_E());
            }
            return formatBuilder.toString();
        }
        if (matcher instanceof NbtMatcher) {
            NBTTagCompound nbtTagCompound;
            boolean greaterThanOne = itemStack.func_190916_E() > 1;
            StringBuilder formatBuilder = new StringBuilder();
            if (greaterThanOne) {
                formatBuilder.append('(');
            }
            formatBuilder.append('<').append(itemStack.func_77973_b().getRegistryName());
            if (itemStack.func_77952_i() > 0) {
                formatBuilder.append(':').append(itemStack.func_77952_i());
            }
            formatBuilder.append('>');
            if (greaterThanOne) {
                formatBuilder.append(" * ").append(itemStack.func_190916_E()).append(')');
            }
            if ((nbtTagCompound = itemStack.func_77978_p()) != null) {
                formatBuilder.append(".withTag(").append(NBTUtils.formatNbt(nbtTagCompound)).append(')');
            }
            return formatBuilder.toString();
        }
        if (matcher instanceof OreDictMatcher) {
            return "<ore:" + OreDictionary.getOreName((int)((OreDictMatcher)matcher).getOre()) + ">";
        }
        return NULL;
    }

    public static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return internal instanceof ItemStack ? (ItemStack)internal : null;
    }

    public static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = CraftTweakerHelper.toObject(list[x]);
        }
        return ingredients;
    }

    public static Object toActualObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return OreDictionary.getOres((String)CraftTweakerHelper.toString((IOreDictEntry)ingredient));
        }
        if (ingredient instanceof IItemStack) {
            return CraftTweakerHelper.toStack((IItemStack)ingredient);
        }
        return null;
    }

    public static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return CraftTweakerHelper.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return CraftTweakerHelper.toStack((IItemStack)ingredient);
        }
        return null;
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }
}

