/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BoilerRecipe
extends MultiblockRecipe {
    public static float timeModifier = 1.0f;
    public final FluidStack fluidOutput;
    public final FluidStack fluidInput;
    int totalProcessTime;
    double heat;
    public static ArrayList<BoilerRecipe> recipeList = new ArrayList();
    public static ArrayList<BoilerFuelRecipe> fuelList = new ArrayList();

    public BoilerRecipe(FluidStack fluidOutput, FluidStack fluidInput, int time) {
        this.fluidOutput = fluidOutput;
        this.fluidInput = fluidInput;
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    public static BoilerRecipe addRecipe(FluidStack fluidOutput, FluidStack fluidInput, int time) {
        BoilerRecipe recipe = new BoilerRecipe(fluidOutput, fluidInput, time);
        recipeList.add(recipe);
        return recipe;
    }

    public static BoilerRecipe findRecipe(FluidStack fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (BoilerRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || !fluidInput.containsFluid(recipe.fluidInput)) continue;
            return recipe;
        }
        return null;
    }

    public static BoilerRecipe findRecipeByFluid(Fluid fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (BoilerRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || fluidInput != recipe.fluidInput.getFluid()) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static BoilerRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        return BoilerRecipe.findRecipe(fluidInput);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public static BoilerFuelRecipe addFuel(FluidStack fluidInput, int time, double heat) {
        BoilerFuelRecipe recipe = new BoilerFuelRecipe(fluidInput, time, heat);
        fuelList.add(recipe);
        return recipe;
    }

    public static BoilerFuelRecipe findFuel(FluidStack fluidInput) {
        for (BoilerFuelRecipe recipe : fuelList) {
            if (fluidInput == null || recipe.fluidInput == null || !fluidInput.containsFluid(recipe.fluidInput)) continue;
            return recipe;
        }
        return null;
    }

    public static BoilerFuelRecipe findFuelByFluid(Fluid fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (BoilerFuelRecipe recipe : fuelList) {
            if (recipe.fluidInput == null || fluidInput != recipe.fluidInput.getFluid()) continue;
            return recipe;
        }
        return null;
    }

    public static class BoilerFuelRecipe
    extends MultiblockRecipe {
        public static float timeModifier = 1.0f;
        public final FluidStack fluidInput;
        int totalProcessTime;
        double heat;

        public BoilerFuelRecipe(FluidStack fluidInput, int time, double heat) {
            this.fluidInput = fluidInput;
            this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
            this.heat = heat;
            this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        }

        public int getMultipleProcessTicks() {
            return 0;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("inputFuel", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
            return nbt;
        }

        public static BoilerFuelRecipe loadFromNBT(NBTTagCompound nbt) {
            FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("inputFuel"));
            return BoilerRecipe.findFuel(fluidInput);
        }

        public int getTotalProcessTime() {
            return this.totalProcessTime;
        }

        public double getHeat() {
            return this.heat;
        }
    }
}

