/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HighPressureSteamTurbineRecipe
extends MultiblockRecipe {
    public static float timeModifier = 1.0f;
    public final FluidStack fluidOutput;
    public final FluidStack fluidInput;
    int totalProcessTime;
    public static ArrayList<HighPressureSteamTurbineRecipe> recipeList = new ArrayList();

    public HighPressureSteamTurbineRecipe(FluidStack fluidOutput, FluidStack fluidInput, int time) {
        this.fluidOutput = fluidOutput;
        this.fluidInput = fluidInput;
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    public static HighPressureSteamTurbineRecipe addFuel(FluidStack fluidOutput, FluidStack fluidInput, int time) {
        HighPressureSteamTurbineRecipe recipe = new HighPressureSteamTurbineRecipe(fluidOutput, fluidInput, time);
        recipeList.add(recipe);
        return recipe;
    }

    public static HighPressureSteamTurbineRecipe findFuel(FluidStack fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (HighPressureSteamTurbineRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || !fluidInput.containsFluid(recipe.fluidInput)) continue;
            return recipe;
        }
        return null;
    }

    public static HighPressureSteamTurbineRecipe findFuelByFluid(Fluid fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (HighPressureSteamTurbineRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || fluidInput != recipe.fluidInput.getFluid()) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static HighPressureSteamTurbineRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        return HighPressureSteamTurbineRecipe.findFuel(fluidInput);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }
}

