/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.ManualPageMultiblock;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.IECustomStateMapper;
import blusunrize.immersiveengineering.client.models.obj.IEOBJLoader;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.ItemEarmuffs;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualPages;
import java.util.Locale;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.client.gui.GuiBoiler;
import mctmods.immersivetechnology.client.gui.GuiDistiller;
import mctmods.immersivetechnology.client.gui.GuiFluidValve;
import mctmods.immersivetechnology.client.gui.GuiLoadController;
import mctmods.immersivetechnology.client.gui.GuiSolarTower;
import mctmods.immersivetechnology.client.gui.GuiStackLimiter;
import mctmods.immersivetechnology.client.gui.GuiTimer;
import mctmods.immersivetechnology.client.gui.GuiTrashItem;
import mctmods.immersivetechnology.client.models.ModelConfigurableSides;
import mctmods.immersivetechnology.client.render.TileRenderBarrelOpen;
import mctmods.immersivetechnology.client.render.TileRenderHighPressureSteamTurbine;
import mctmods.immersivetechnology.client.render.TileRenderSolarReflector;
import mctmods.immersivetechnology.client.render.TileRenderSteamTurbine;
import mctmods.immersivetechnology.client.render.TileRenderSteelSheetmetalTank;
import mctmods.immersivetechnology.client.render.TileRendererGasTurbine;
import mctmods.immersivetechnology.common.CommonProxy;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.blocks.BlockITFluid;
import mctmods.immersivetechnology.common.blocks.BlockValve;
import mctmods.immersivetechnology.common.blocks.connectors.tileentities.TileEntityTimer;
import mctmods.immersivetechnology.common.blocks.connectors.types.BlockType_Connectors;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockAlternator;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockBoiler;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockCoolingTower;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockDistiller;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockElectrolyticCrucibleBattery;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockGasTurbine;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockHeatExchanger;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockHighPressureSteamTurbine;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockMeltingCrucible;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockRadiator;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockSolarMelter;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockSolarReflector;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockSolarTower;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockSteamTurbine;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockSteelSheetmetalTank;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBarrelOpen;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityDistillerMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityGasTurbineMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityHighPressureSteamTurbineMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarReflectorMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarTowerMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteamTurbineMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteelSheetmetalTankMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityTrashItem;
import mctmods.immersivetechnology.common.blocks.metal.types.BlockType_MetalBarrel;
import mctmods.immersivetechnology.common.items.ItemITBase;
import mctmods.immersivetechnology.common.tileentities.TileEntityFluidValve;
import mctmods.immersivetechnology.common.tileentities.TileEntityLoadController;
import mctmods.immersivetechnology.common.tileentities.TileEntityStackLimiter;
import mctmods.immersivetechnology.common.util.ITLogger;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.MessageRequestUpdate;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final String CAT_POWER = "it_power";
    public static final String CAT_IT = "it";
    public static float volumeAdjustment = 1.0f;

    @Override
    public void preInit() {
        ClientUtils.mc().func_147110_a().enableStencil();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)IEOBJLoader.instance);
        OBJLoader.INSTANCE.addDomain("immersivetech");
        IEOBJLoader.instance.addDomain("immersivetech");
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelConfigurableSides.Loader());
    }

    @SubscribeEvent
    public void PlayerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent e) {
        ITSoundHandler.DeleteAllSounds();
    }

    @SubscribeEvent
    public void PlayerLeftSession(PlayerEvent.PlayerLoggedOutEvent e) {
        ITSoundHandler.DeleteAllSounds();
    }

    @SubscribeEvent
    public void PlayerDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        ITSoundHandler.DeleteAllSounds();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!ITUtils.REMOVE_FROM_TICKING.isEmpty() && event.phase == TickEvent.Phase.END) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                ITLogger.warn("ClientProxy has tried to access null world! This shouldn't normally happen...");
            } else {
                world.field_175730_i.removeAll(ITUtils.REMOVE_FROM_TICKING);
                ITUtils.REMOVE_FROM_TICKING.clear();
            }
        }
        this.calculateVolume();
    }

    public void calculateVolume() {
        float prevVolume = volumeAdjustment;
        EntityPlayerSP player = ClientUtils.mc().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        volumeAdjustment = !stack.func_190926_b() ? (IEContent.itemEarmuffs.equals(stack.func_77973_b()) ? ItemEarmuffs.getVolumeMod((ItemStack)stack) : (ItemNBTHelper.hasKey((ItemStack)stack, (String)"IE:Earmuffs") ? (!(stack = ItemNBTHelper.getItemStack((ItemStack)stack, (String)"IE:Earmuffs")).func_190926_b() && IEContent.itemEarmuffs.equals(stack.func_77973_b()) ? ItemEarmuffs.getVolumeMod((ItemStack)stack) : 1.0f) : 1.0f)) : 1.0f;
        if (prevVolume != volumeAdjustment) {
            ITSoundHandler.UpdateAllVolumes();
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        ResourceLocation loc;
        WireApi.registerConnectorForRender((String)"conn_timer", (ResourceLocation)new ResourceLocation("immersivetech:block/connector/connectors_timer.obj.ie"), null);
        WireApi.registerConnectorForRender((String)"conn_con_net", (ResourceLocation)new ResourceLocation("immersivetech:block/connector/connectors_con_net.obj.ie"), null);
        for (Block block : ITContent.registeredITBlocks) {
            loc = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
            Item blockItem = Item.func_150898_a((Block)block);
            if (blockItem == null) {
                throw new RuntimeException("ITEMBLOCK for" + loc + " : " + block + " IS NULL");
            }
            if (block instanceof IEBlockInterfaces.IIEMetaBlock) {
                IEBlockInterfaces.IIEMetaBlock ieMetaBlock = (IEBlockInterfaces.IIEMetaBlock)block;
                if (ieMetaBlock.useCustomStateMapper()) {
                    ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)IECustomStateMapper.getStateMapper((IEBlockInterfaces.IIEMetaBlock)ieMetaBlock));
                }
                ModelLoader.setCustomMeshDefinition((Item)blockItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return new ModelResourceLocation(loc, "inventory");
                    }
                });
                for (int meta = 0; meta < ieMetaBlock.getMetaEnums().length; ++meta) {
                    String custom;
                    String prop;
                    String location = loc.toString();
                    String string = prop = ieMetaBlock.appendPropertiesToState() ? "inventory," + ieMetaBlock.getMetaProperty().func_177701_a() + "=" + ieMetaBlock.getMetaEnums()[meta].toString().toLowerCase(Locale.US) : null;
                    if (ieMetaBlock.useCustomStateMapper() && (custom = ieMetaBlock.getCustomStateMapping(meta, true)) != null) {
                        location = location + "_" + custom;
                    }
                    try {
                        ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, prop));
                        continue;
                    }
                    catch (NullPointerException npe) {
                        throw new RuntimeException("WELP! apparently " + ieMetaBlock + " lacks an item!", npe);
                    }
                }
                continue;
            }
            if (block instanceof BlockITFluid) {
                ClientProxy.mapFluidState(block, ((BlockITFluid)block).getFluid());
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
        for (Item item : ITContent.registeredITItems) {
            if (item instanceof ItemBlock) continue;
            if (item instanceof ItemITBase) {
                ItemITBase ipMetaItem = (ItemITBase)item;
                if (ipMetaItem.registerSubModels && ipMetaItem.getSubNames() != null && ipMetaItem.getSubNames().length > 0) {
                    for (int meta = 0; meta < ipMetaItem.getSubNames().length; ++meta) {
                        ResourceLocation loc2 = new ResourceLocation("immersivetech", ipMetaItem.itemName + "/" + ipMetaItem.getSubNames()[meta]);
                        ModelBakery.registerItemVariants((Item)ipMetaItem, (ResourceLocation[])new ResourceLocation[]{loc2});
                        ModelLoader.setCustomModelResourceLocation((Item)ipMetaItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc2, "inventory"));
                    }
                    continue;
                }
                final ResourceLocation loc3 = new ResourceLocation("immersivetech", ipMetaItem.itemName);
                ModelBakery.registerItemVariants((Item)ipMetaItem, (ResourceLocation[])new ResourceLocation[]{loc3});
                ModelLoader.setCustomMeshDefinition((Item)ipMetaItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return new ModelResourceLocation(loc3, "inventory");
                    }
                });
                continue;
            }
            loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{loc});
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(loc, "inventory");
                }
            });
        }
    }

    @Override
    public void preInitEnd() {
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySteamTurbineMaster.class, (TileEntitySpecialRenderer)new TileRenderSteamTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGasTurbineMaster.class, (TileEntitySpecialRenderer)new TileRendererGasTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarReflectorMaster.class, (TileEntitySpecialRenderer)new TileRenderSolarReflector());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHighPressureSteamTurbineMaster.class, (TileEntitySpecialRenderer)new TileRenderHighPressureSteamTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrelOpen.class, (TileEntitySpecialRenderer)new TileRenderBarrelOpen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySteelSheetmetalTankMaster.class, (TileEntitySpecialRenderer)new TileRenderSteelSheetmetalTank());
        ImmersiveTechnology.packetHandler.registerMessage(MessageTileSync.HandlerClient.class, MessageTileSync.class, 0, Side.CLIENT);
        ImmersiveTechnology.packetHandler.registerMessage(MessageTileSync.HandlerServer.class, MessageTileSync.class, 0, Side.SERVER);
        ImmersiveTechnology.packetHandler.registerMessage(MessageStopSound.HandlerClient.class, MessageStopSound.class, 1, Side.CLIENT);
        ImmersiveTechnology.packetHandler.registerMessage(MessageRequestUpdate.HandlerClient.class, MessageRequestUpdate.class, 2, Side.CLIENT);
        ImmersiveTechnology.packetHandler.registerMessage(BinaryMessageTileSync.HandlerClient.class, BinaryMessageTileSync.class, 3, Side.CLIENT);
        ImmersiveTechnology.packetHandler.registerMessage(BinaryMessageTileSync.HandlerServer.class, BinaryMessageTileSync.class, 3, Side.SERVER);
    }

    @Override
    public void postInit() {
        if (Config.ITConfig.Machines.Multiblock.enable_boiler) {
            ManualHelper.addEntry((String)"boiler", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "boiler0", (MultiblockHandler.IMultiblock)MultiblockBoiler.instance), new ManualPages.Text(ManualHelper.getManual(), "boiler1"), new ManualPages.Text(ManualHelper.getManual(), "boiler2")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_solarTower) {
            ManualHelper.addEntry((String)"solarTower", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "solarTower0", (MultiblockHandler.IMultiblock)MultiblockSolarTower.instance), new ManualPages.Text(ManualHelper.getManual(), "solarTower1"), new ManualPageMultiblock(ManualHelper.getManual(), "solarTower2", (MultiblockHandler.IMultiblock)MultiblockSolarReflector.instance), new ManualPages.Text(ManualHelper.getManual(), "solarTower3")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_heatExchanger) {
            ManualHelper.addEntry((String)"heatExchanger", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "heatExchanger0", (MultiblockHandler.IMultiblock)MultiblockHeatExchanger.instance), new ManualPages.Text(ManualHelper.getManual(), "heatExchanger1")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_gasTurbine || Config.ITConfig.Machines.Multiblock.enable_steamTurbine) {
            ManualHelper.addEntry((String)"alternator", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "alternator0", (MultiblockHandler.IMultiblock)MultiblockAlternator.instance), new ManualPages.Text(ManualHelper.getManual(), "alternator1"), new ManualPages.Image(ManualHelper.getManual(), "alternator2", new String[]{"immersivetech:textures/misc/alternator.png;0;0;110;50"})});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_steamTurbine) {
            ManualHelper.addEntry((String)"steamTurbine", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "steamTurbine0", (MultiblockHandler.IMultiblock)MultiblockSteamTurbine.instance), new ManualPages.Text(ManualHelper.getManual(), "steamTurbine1"), new ManualPages.Text(ManualHelper.getManual(), "steamTurbine2")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_highPressureSteamTurbine) {
            ManualHelper.addEntry((String)"highPressureSteamTurbine", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "highPressureSteamTurbine0", (MultiblockHandler.IMultiblock)MultiblockHighPressureSteamTurbine.instance), new ManualPages.Text(ManualHelper.getManual(), "highPressureSteamTurbine1"), new ManualPages.Text(ManualHelper.getManual(), "highPressureSteamTurbine2")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_gasTurbine) {
            ManualHelper.addEntry((String)"gasTurbine", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "gasTurbine0", (MultiblockHandler.IMultiblock)MultiblockGasTurbine.instance), new ManualPages.Text(ManualHelper.getManual(), "gasTurbine1"), new ManualPages.Text(ManualHelper.getManual(), "gasTurbine2"), new ManualPages.Text(ManualHelper.getManual(), "gasTurbine3")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_coolingTower) {
            ManualHelper.addEntry((String)"coolingTower", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "coolingTower0", (MultiblockHandler.IMultiblock)MultiblockCoolingTower.instance), new ManualPages.Text(ManualHelper.getManual(), "coolingTower1")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_radiator) {
            ManualHelper.addEntry((String)"radiator", (String)CAT_POWER, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "radiator0", (MultiblockHandler.IMultiblock)MultiblockRadiator.instance), new ManualPages.Text(ManualHelper.getManual(), "radiator1")});
        }
        ManualHelper.addEntry((String)"controlBlocks", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "controlBlocks0", new Object[]{new ItemStack(ITContent.blockValve, 1, BlockValve.BlockType_Valve.STACK_LIMITER.getMeta())}), new ManualPages.Crafting(ManualHelper.getManual(), "controlBlocks1", new Object[]{new ItemStack(ITContent.blockValve, 1, BlockValve.BlockType_Valve.LOAD_CONTROLLER.getMeta())}), new ManualPages.Crafting(ManualHelper.getManual(), "controlBlocks2", new Object[]{new ItemStack(ITContent.blockValve, 1, BlockValve.BlockType_Valve.FLUID_VALVE.getMeta())})});
        ManualHelper.addEntry((String)"redstone", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "redstone0", new Object[]{new ItemStack(ITContent.blockConnectors, 1, BlockType_Connectors.CONNECTORS_TIMER.getMeta())})});
        ManualHelper.addEntry((String)"openBarrel", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "openBarrel0", new Object[]{new ItemStack(ITContent.blockMetalBarrel, 1, BlockType_MetalBarrel.BARREL_OPEN.getMeta())})});
        ManualHelper.addEntry((String)"steelBarrel", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "steelBarrel0", new Object[]{new ItemStack(ITContent.blockMetalBarrel, 2, BlockType_MetalBarrel.BARREL_STEEL.getMeta())})});
        ManualHelper.addEntry((String)"steelTank", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "steelTank0", (MultiblockHandler.IMultiblock)MultiblockSteelSheetmetalTank.instance), new ManualPages.Text(ManualHelper.getManual(), "steelTank1")});
        if (Config.ITConfig.Machines.Multiblock.enable_distiller) {
            ManualHelper.addEntry((String)"distiller", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "distiller0", (MultiblockHandler.IMultiblock)MultiblockDistiller.instance), new ManualPages.Text(ManualHelper.getManual(), "distiller1")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_meltingCrucible) {
            ManualHelper.addEntry((String)"meltingCrucible", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "meltingCrucible0", (MultiblockHandler.IMultiblock)MultiblockMeltingCrucible.instance), new ManualPages.Text(ManualHelper.getManual(), "meltingCrucible1")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_solarMelter) {
            ManualHelper.addEntry((String)"solarMelter", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "solarMelter0", (MultiblockHandler.IMultiblock)MultiblockSolarMelter.instance), new ManualPages.Text(ManualHelper.getManual(), "solarMelter1")});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_electrolyticCrucibleBattery) {
            ManualHelper.addEntry((String)"electrolyticCrucibleBattery", (String)CAT_IT, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "electrolyticCrucibleBattery0", (MultiblockHandler.IMultiblock)MultiblockElectrolyticCrucibleBattery.instance), new ManualPages.Text(ManualHelper.getManual(), "electrolyticCrucibleBattery1"), new ManualPages.Text(ManualHelper.getManual(), "electrolyticCrucibleBattery2")});
        }
    }

    private static void mapFluidState(Block block, Fluid fluid) {
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        if (item != Items.field_190931_a) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @Override
    public void clearRenderCaches() {
        for (Runnable r : IEApi.renderCacheClearers) {
            r.run();
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile instanceof IEBlockInterfaces.IGuiTile) {
            Object gui = null;
            if (ID == 0 && tile instanceof TileEntityBoilerMaster) {
                gui = new GuiBoiler(player.field_71071_by, (TileEntityBoilerMaster)tile);
            }
            if (ID == 2 && tile instanceof TileEntityDistillerMaster) {
                gui = new GuiDistiller(player.field_71071_by, (TileEntityDistillerMaster)tile);
            }
            if (ID == 3 && tile instanceof TileEntitySolarTowerMaster) {
                gui = new GuiSolarTower(player.field_71071_by, (TileEntitySolarTowerMaster)tile);
            }
            if (ID == 4 && tile instanceof TileEntityTimer) {
                gui = new GuiTimer(player.field_71071_by, (TileEntityTimer)tile);
            }
            if (ID == 5 && tile instanceof TileEntityTrashItem) {
                gui = new GuiTrashItem(player.field_71071_by, (TileEntityTrashItem)tile);
            }
            if (ID == 6 && tile instanceof TileEntityFluidValve) {
                gui = new GuiFluidValve((TileEntityFluidValve)tile);
            }
            if (ID == 7 && tile instanceof TileEntityLoadController) {
                gui = new GuiLoadController((TileEntityLoadController)tile);
            }
            if (ID == 8 && tile instanceof TileEntityStackLimiter) {
                gui = new GuiStackLimiter((TileEntityStackLimiter)tile);
            }
            return gui;
        }
        return null;
    }

    static {
        IEApi.renderCacheClearers.add(ModelConfigurableSides.modelCache::clear);
    }

    static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation("immersivetech:fluid_block", fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

