/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityBarrelSteel
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
ITFluidTank.TankListener {
    private static int tankSize = Config.ITConfig.Barrels.barrel_steel_tankSize;
    private static int transferSpeed = Config.ITConfig.Barrels.barrel_steel_transferSpeed;
    public int[] sideConfig = new int[]{1, 0};
    public ITFluidTank tank;
    private int sleep = 0;
    SidedFluidHandler[] sidedFluidHandler = new SidedFluidHandler[]{new SidedFluidHandler(this, EnumFacing.DOWN), new SidedFluidHandler(this, EnumFacing.UP)};
    SidedFluidHandler nullsideFluidHandler = new SidedFluidHandler(this, null);

    public void createTank() {
        this.tank = new ITFluidTank(tankSize, this);
    }

    public TileEntityBarrelSteel() {
        this.createTank();
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 2) {
            this.sideConfig = new int[]{-1, 0};
        }
        this.readTank(nbt);
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        this.writeTank(nbt, false);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int index = 0; index < 2; ++index) {
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[index] != 1) continue;
            EnumFacing face = EnumFacing.func_82600_a((int)index);
            IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(face), (EnumFacing)face.func_176734_d());
            if (output == null) continue;
            if (this.sleep == 0) {
                FluidStack accepted = Utils.copyFluidStackWithAmount((FluidStack)this.tank.getFluid(), (int)Math.min(transferSpeed, this.tank.getFluidAmount()), (boolean)false);
                if (accepted == null) {
                    this.sleep = 20;
                    return;
                }
                accepted.amount = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)true), false);
                if (accepted.amount > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)false), true);
                    this.tank.drain(drained, true);
                    this.sleep = 0;
                    continue;
                }
                this.sleep = 20;
                continue;
            }
            --this.sleep;
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String[] stringArray;
            FluidStack fluid = this.tank.getFluid();
            if (fluid != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = TranslationKey.OVERLAY_OSD_BARREL_NORMAL_FIRST_LINE.format(fluid.getLocalizedName(), fluid.amount);
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = TranslationKey.GUI_EMPTY.text();
            }
            return stringArray;
        }
        return null;
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.func_176740_k() == EnumFacing.Axis.Y)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.func_176740_k() == EnumFacing.Axis.Y)) {
            return (T)(facing == null ? this.nullsideFluidHandler : this.sidedFluidHandler[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    public IEEnums.SideConfig getSideConfig(int side) {
        if (side > 1) {
            return IEEnums.SideConfig.NONE;
        }
        return IEEnums.SideConfig.values()[this.sideConfig[side] + 1];
    }

    public boolean toggleSide(int side, EntityPlayer p) {
        if (side != 0 && side != 1) {
            return false;
        }
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        return true;
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
        }
    }

    public static class SidedFluidHandler
    implements IFluidHandler {
        public TileEntityBarrelSteel barrel;
        EnumFacing facing;

        SidedFluidHandler(TileEntityBarrelSteel barrel, EnumFacing facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || this.facing != null && this.barrel.sideConfig[this.facing.ordinal()] != 0 || !this.barrel.isFluidValid(resource)) {
                return 0;
            }
            int input = this.barrel.tank.fill(resource, doFill);
            return input;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.facing != null && this.barrel.sideConfig[this.facing.ordinal()] != 1) {
                return null;
            }
            FluidStack output = this.barrel.tank.drain(maxDrain, doDrain);
            return output;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.barrel.tank.getTankProperties();
        }
    }
}

