/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.multiblock;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.common.util.multiblock.AirRef;
import mctmods.immersivetechnology.common.util.multiblock.IRefComparable;
import mctmods.immersivetechnology.common.util.multiblock.ItemStackRef;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockJSONSchema;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockUtils;
import mctmods.immersivetechnology.common.util.multiblock.OreDictRef;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ITMultiblock<T extends TileEntityMultiblockPart<T>>
implements MultiblockHandler.IMultiblock {
    public String uniqueName;
    public IBlockState masterBlockState;
    public IBlockState slaveBlockState;
    public int height;
    public int length;
    public int width;
    public int masterX;
    public int masterY;
    public int masterZ;
    public IRefComparable trigger;
    public IRefComparable[][][] structure;
    public IngredientStack[] materials;
    public byte[][][] collisionData;
    public ItemStack[][][] structureExport;
    public PoIJSONSchema[] pointsOfInterest;

    public ItemStack[][][] getStructureManual() {
        return this.structureExport;
    }

    public IngredientStack[] getTotalMaterials() {
        return this.materials;
    }

    public boolean isBlockTrigger(IBlockState state) {
        return this.trigger.isEquals(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
    }

    public ITMultiblock(String structurePath, IBlockState master, IBlockState slave) {
        MultiblockJSONSchema data = MultiblockUtils.Load(structurePath);
        if (data == null) {
            throw new IllegalArgumentException(String.format("Invalid or missing multiblock file %s", structurePath));
        }
        this.uniqueName = data.uniqueName;
        this.masterBlockState = master;
        this.slaveBlockState = slave;
        this.width = data.width;
        this.length = data.length;
        this.height = data.height;
        this.pointsOfInterest = data.pointsOfInterest;
        this.masterX = data.master.x;
        this.masterY = data.master.y;
        this.masterZ = data.master.z;
        this.collisionData = data.AABB;
        this.structure = MultiblockUtils.GetStructure(data, this.width, this.length, this.height);
        this.materials = MultiblockUtils.GetMaterials(data);
        if (data.master.mod.equals("ore")) {
            this.trigger = new OreDictRef(data.master.name);
        } else {
            Item item = Item.func_111206_d((String)(data.master.mod + ":" + data.master.name));
            if (item == null) {
                throw new IllegalArgumentException(String.format("Invalid item %s:%s", data.master.mod, data.master.name));
            }
            this.trigger = new ItemStackRef(new ItemStack(item, 1, data.master.meta));
        }
        this.structureExport = MultiblockUtils.Convert(this.structure);
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ItemStack hammer;
        side = side == EnumFacing.UP || side == EnumFacing.DOWN ? EnumFacing.func_176733_a((double)player.field_70177_z) : side.func_176734_d();
        boolean mirror = false;
        if (this.isInvalid(world, pos, side, mirror) && this.isInvalid(world, pos, side, mirror = true)) {
            return false;
        }
        BlockPos origin = pos.func_177967_a(side, -this.masterZ).func_177967_a(side.func_176746_e(), mirror ? this.width - 1 - this.masterX : -this.masterX).func_177967_a(EnumFacing.DOWN, this.masterY);
        ItemStack itemStack = hammer = player.func_184614_ca().func_77973_b().getToolClasses(player.func_184614_ca()).contains("IE_HAMMER") ? player.func_184614_ca() : player.func_184592_cb();
        if (MultiblockHandler.fireMultiblockFormationEventPost((EntityPlayer)player, (MultiblockHandler.IMultiblock)this, (BlockPos)pos, (ItemStack)hammer).isCanceled()) {
            return false;
        }
        for (int h = 0; h < this.height; ++h) {
            for (int l = 0; l < this.length; ++l) {
                for (int w = 0; w < this.width; ++w) {
                    int position = h * (this.width * this.length) + l * this.width + w;
                    if (this.collisionData[position] == null) continue;
                    BlockPos pos2 = ITUtils.LocalOffsetToWorldBlockPos(origin, mirror ? -w : w, h, l, side);
                    world.func_175656_a(pos2, ITUtils.AreBlockPosIdentical(pos, pos2) ? this.masterBlockState : this.slaveBlockState);
                    TileEntityMultiblockPart tile = (TileEntityMultiblockPart)world.func_175625_s(pos2);
                    if (tile == null) continue;
                    tile.facing = side;
                    tile.formed = true;
                    tile.field_174879_c = position;
                    tile.offset = new int[]{pos2.func_177958_n() - pos.func_177958_n(), pos2.func_177956_o() - pos.func_177956_o(), pos2.func_177952_p() - pos.func_177952_p()};
                    tile.mirrored = mirror;
                    tile.func_70296_d();
                    world.func_175641_c(pos2, this.slaveBlockState.func_177230_c(), 255, 0);
                }
            }
        }
        return true;
    }

    boolean isInvalid(World world, BlockPos pos, EnumFacing side, boolean mirror) {
        BlockPos origin = pos.func_177967_a(side, -this.masterZ).func_177967_a(side.func_176746_e(), mirror ? this.width - 1 - this.masterX : -this.masterX).func_177967_a(EnumFacing.DOWN, this.masterY);
        for (int h = 0; h < this.height; ++h) {
            for (int l = 0; l < this.length; ++l) {
                for (int w = 0; w < this.width; ++w) {
                    BlockPos blockPos;
                    IBlockState state;
                    if (this.structure[h][l][w] == AirRef.instance || this.structure[h][l][w].isEquals(new ItemStack((state = world.func_180495_p(blockPos = ITUtils.LocalOffsetToWorldBlockPos(origin, mirror ? -w : w, h, l, side))).func_177230_c(), 1, state.func_177230_c().func_176201_c(state)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPointOfInterest(EnumFacing accessSide, EnumFacing machineFacing, int position, String name) {
        for (PoIJSONSchema poi : this.pointsOfInterest) {
            if (!poi.name.equals(name) || poi.position != position || poi.facing.LocalToGlobal(machineFacing) != accessSide) continue;
            return true;
        }
        return false;
    }
}

