/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.items;

import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.init.ModItems;
import com.focamacho.mysticaladaptations.lib.BlockCheck;
import com.focamacho.mysticaladaptations.util.Utils;
import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SeedExtractor
extends Item {
    private final Item.ToolMaterial toolMaterial;

    public SeedExtractor(String name, Item.ToolMaterial material, int durability) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77656_e(durability);
        this.func_77637_a(MysticalAdaptations.tabMysticalAdaptations);
        this.func_77625_d(1);
        this.toolMaterial = material;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack seed;
        ItemStack itemstack = player.func_184586_b(hand);
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, player, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        ItemStack blockItem = iblockstate.func_177230_c().getPickBlock(iblockstate, raytraceresult, worldIn, pos, player);
        if (player.func_175151_a(pos, raytraceresult.field_178784_b, itemstack) && (seed = BlockCheck.getSeedFromBlock(itemstack, blockItem, block)) != null) {
            if (!worldIn.field_72995_K) {
                this.seedExtractorUse(worldIn, player, itemstack, seed, pos);
            } else {
                this.spawnParticles(pos, worldIn, iblockstate);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public void seedExtractorUse(World worldIn, EntityPlayer player, ItemStack extractor, ItemStack seed, BlockPos pos) {
        worldIn.func_175698_g(pos);
        EntityItem seedDrop = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), seed);
        player.func_184811_cZ().func_185145_a(extractor.func_77973_b(), 20);
        worldIn.func_72838_d((Entity)seedDrop);
        extractor.func_77972_a(1, (EntityLivingBase)player);
    }

    private void spawnParticles(BlockPos pos, World world, IBlockState state) {
        Random rand = new Random();
        for (int k = 0; k < 20; ++k) {
            double xCoord = (double)pos.func_177958_n() + rand.nextDouble() * 0.6 - 0.3;
            double yCoord = (double)pos.func_177956_o() + rand.nextDouble() * 0.6;
            double zCoord = (double)pos.func_177952_p() + rand.nextDouble() * 0.6 - 0.3;
            double xSpeed = rand.nextGaussian() * 0.02;
            double ySpeed = rand.nextGaussian() * 0.2;
            double zSpeed = rand.nextGaussian() * 0.02;
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flagIn) {
        int tier = this.getExtractorTier();
        list.add(ChatFormatting.GRAY + "Tier: " + Utils.getColorFromTier(tier) + tier);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ModConfig.ENCHANTABLE_EXTRACTOR;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.toolMaterial.func_78000_c() - 1.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.4, 0));
        }
        return multimap;
    }

    public int getExtractorTier() {
        return SeedExtractor.getExtractorTier(this);
    }

    public static int getExtractorTier(Item itemExtractor) {
        if (itemExtractor.equals(ModItems.INFERIUM_SEED_EXTRACTOR)) {
            return 1;
        }
        if (itemExtractor.equals(ModItems.PRUDENTIUM_SEED_EXTRACTOR)) {
            return 2;
        }
        if (itemExtractor.equals(ModItems.INTERMEDIUM_SEED_EXTRACTOR)) {
            return 3;
        }
        if (itemExtractor.equals(ModItems.SUPERIUM_SEED_EXTRACTOR)) {
            return 4;
        }
        if (itemExtractor.equals(ModItems.SUPREMIUM_SEED_EXTRACTOR)) {
            return 5;
        }
        if (itemExtractor.equals(ModItems.INSANIUM_SEED_EXTRACTOR)) {
            return 6;
        }
        return 0;
    }
}

