/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.items.insanium;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.armor.ArmorType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsaniumArmor
extends ItemArmor {
    public InsaniumArmor(String name, ItemArmor.ArmorMaterial material, int index, EntityEquipmentSlot slot) {
        super(material, index, slot);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAdaptations.tabMysticalAdaptations);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Tooltips.DURABILITY + "\u00a75" + (stack.func_77958_k() - stack.func_77952_i()));
        if (com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_ARMOR_HUNGERLESS) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a75" + I18n.func_74838_a((String)"tooltip.mysticaladaptations.hungerless"));
        } else if (com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_ARMOR_SATURATION) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a75" + Utils.localize((String)MobEffects.field_76443_y.func_76393_a()));
        } else if (ModConfig.confSupremiumFlight) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a75" + Tooltips.FLIGHT);
        }
        NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack);
        if (tag.func_74764_b("ArmorType")) {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + ArmorType.byIndex((int)tag.func_74762_e("ArmorType")).getLocalizedName());
        } else {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + Tooltips.EMPTY);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ArmorType type;
        NBTTagCompound tag;
        if (ModConfig.confSetBonuses && InsaniumArmor.isFullSet(player)) {
            if (player.func_70090_H()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 5, 0, true, false));
            }
            if (com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_ARMOR_FIRERESISTANCE && player.func_70027_ad()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 5, 0, true, false));
            }
            if (com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_ARMOR_SATURATION) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 5, 0, true, false));
            }
            if (com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_ARMOR_HUNGERLESS && player.func_71024_bL().func_75121_c()) {
                player.func_71024_bL().func_75114_a(20);
            }
        }
        if ((tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ArmorType") && (type = ArmorType.byIndex((int)tag.func_74762_e("ArmorType"))) != null) {
            type.getSpecialAbility(world, player);
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public static boolean isFullSet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !head.func_190926_b() && head.func_77973_b() instanceof InsaniumArmor && !chest.func_190926_b() && chest.func_77973_b() instanceof InsaniumArmor && !legs.func_190926_b() && legs.func_77973_b() instanceof InsaniumArmor && !feet.func_190926_b() && feet.func_77973_b() instanceof InsaniumArmor;
    }

    public static class AbilityHandler {
        public static List<String> playersWithSet = new ArrayList<String>();
        public static List<String> playersWithSpeed = new ArrayList<String>();

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.func_130014_f_().field_72995_K;
        }

        public boolean hasSpeed(EntityPlayer player) {
            NBTTagCompound tag;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.LEGS);
            return stack.func_77973_b() == ModItems.INSANIUM_LEGGINGS && (tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ArmorType") && tag.func_74762_e("ArmorType") == ArmorType.SPEED.getIndex();
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                String key = AbilityHandler.playerKey(player);
                Boolean hasSet = InsaniumArmor.isFullSet(player);
                if (playersWithSet.contains(key)) {
                    if (hasSet.booleanValue()) {
                        if (ModConfig.confSupremiumFlight) {
                            player.field_71075_bZ.field_75101_c = true;
                        }
                        if (ModConfig.confSetBonuses) {
                            player.field_70138_W = 1.0625f;
                            boolean flying = player.field_71075_bZ.field_75100_b;
                            if (flying) {
                                boolean sneaking = player.func_70093_af();
                                float speed = 0.08f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                                if (player.field_191988_bg > 0.0f) {
                                    player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                                } else if (player.field_191988_bg < 0.0f) {
                                    player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                                }
                                if (player.field_70702_br != 0.0f) {
                                    player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                                }
                            }
                        }
                    } else {
                        player.field_70138_W = 0.6f;
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithSet.remove(key);
                    }
                } else if (hasSet.booleanValue()) {
                    playersWithSet.add(key);
                }
                boolean hasSpeed = this.hasSpeed(player);
                if (playersWithSpeed.contains(key)) {
                    if (hasSpeed) {
                        boolean swimming;
                        boolean flying = player.field_71075_bZ.field_75100_b;
                        boolean bl = swimming = player.func_70055_a(Material.field_151586_h) || player.func_70090_H();
                        if (player.field_70122_E || flying || swimming) {
                            boolean sneaking = player.func_70093_af();
                            boolean sprinting = player.func_70051_ag();
                            float speed = 0.1f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f) * (!sprinting ? 0.6f : 1.2f);
                            if (player.field_191988_bg > 0.0f) {
                                player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                            } else if (player.field_191988_bg < 0.0f) {
                                player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                            }
                            if (player.field_70702_br != 0.0f) {
                                player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                            }
                        }
                    } else {
                        playersWithSpeed.remove(key);
                    }
                } else if (hasSpeed) {
                    playersWithSpeed.add(key);
                }
            }
        }
    }
}

