/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.items.insanium;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.util.ToolTools;
import com.blakebr0.mysticalagriculture.items.tools.ToolType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsaniumAxe
extends ItemAxe {
    public TextFormatting color;

    public InsaniumAxe(String name, Item.ToolMaterial material, float damage, TextFormatting color) {
        super(material, damage, -3.2f);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAdaptations.tabMysticalAdaptations);
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        if (ModConfig.INSANIUM_AXE_UP) {
            tooltip.add(I18n.func_74838_a((String)"tooltip.mysticaladaptations.insanium_axe_up"));
        }
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack);
        if (tag.func_74764_b("ToolType")) {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + ToolType.byIndex((int)tag.func_74762_e("ToolType")).getLocalizedName());
        } else {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + Tooltips.EMPTY);
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (stack.func_77973_b() == ModItems.INSANIUM_AXE) {
            NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack);
            if (tag.func_74764_b("ToolType")) {
                if (tag.func_74762_e("ToolType") == ToolType.MINING_AOE.getIndex()) {
                    boolean blocks = false;
                    RayTraceResult ray = ToolTools.getBlockWithinReach((World)player.func_130014_f_(), (EntityPlayer)player);
                    if (ray != null) {
                        int side = ray.field_178784_b.ordinal();
                        blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
                    }
                    return blocks;
                }
            } else if (ModConfig.INSANIUM_AXE_UP) {
                for (BlockPos woodPos : this.getAllWood(player.func_130014_f_(), pos)) {
                    if (woodPos == pos) continue;
                    IBlockState aoeState = player.func_130014_f_().func_180495_p(woodPos);
                    if (aoeState.func_185887_b(player.func_130014_f_(), woodPos) <= player.func_130014_f_().func_180495_p(pos).func_185887_b(player.func_130014_f_(), pos) + 5.0f) {
                        if (!aoeState.func_177230_c().isToolEffective("axe", aoeState)) continue;
                        this.canHarvest(player.func_130014_f_(), woodPos, true, stack, player);
                        continue;
                    }
                    return false;
                }
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        block10: {
            int xRange = radius;
            int yRange = radius;
            int zRange = 0;
            if (side == 0 || side == 1) {
                zRange = radius;
                yRange = 0;
            }
            if (side == 4 || side == 5) {
                xRange = 0;
                zRange = radius;
            }
            IBlockState state = world.func_180495_p(pos);
            float hardness = state.func_185887_b(world, pos);
            if (!this.canHarvest(world, pos, false, stack, player)) {
                return false;
            }
            if (radius <= 0 || !(hardness >= 0.2f) || !state.func_177230_c().isToolEffective("axe", state)) break block10;
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            if (ModConfig.INSANIUM_AXE_UP) {
                for (BlockPos aoePos : blocks) {
                    for (BlockPos woodPos : this.getAllWood(world, aoePos)) {
                        if (woodPos == pos) continue;
                        IBlockState aoeState = world.func_180495_p(woodPos);
                        if (aoeState.func_185887_b(world, woodPos) <= hardness + 5.0f) {
                            if (!aoeState.func_177230_c().isToolEffective("axe", aoeState)) continue;
                            this.canHarvest(world, woodPos, true, stack, player);
                            continue;
                        }
                        return false;
                    }
                }
            } else {
                for (BlockPos aoePos : blocks) {
                    if (aoePos == pos) continue;
                    IBlockState aoeState = world.func_180495_p(aoePos);
                    if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                        if (!aoeState.func_177230_c().isToolEffective("axe", aoeState)) continue;
                        this.canHarvest(world, aoePos, true, stack, player);
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE((ItemStack)stack, (World)world, (EntityPlayer)player, (BlockPos)pos);
        }
        return false;
    }

    private List<BlockPos> getAllWood(World world, BlockPos pos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos blockpos = pos.func_177984_a();
        while (world.func_180495_p(blockpos).func_177230_c().isWood((IBlockAccess)world, blockpos)) {
            blockPosList.add(blockpos);
            blockpos = blockpos.func_177984_a();
        }
        return blockPosList;
    }
}

