/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.items.insanium;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.util.ToolTools;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.init.ModItems;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class InsaniumPaxel
extends ItemTool {
    public ItemStack repairMaterial;
    public TextFormatting color;

    public InsaniumPaxel(String name, Item.ToolMaterial material, TextFormatting color) {
        super(4.0f, -3.2f, material, new HashSet());
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAdaptations.tabMysticalAdaptations);
        this.setHarvestLevel("pickaxe", material.func_77996_d());
        this.setHarvestLevel("shovel", material.func_77996_d());
        this.setHarvestLevel("axe", material.func_77996_d());
        this.func_77656_e((int)((double)material.func_77997_a() * 1.5));
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        if (ModConfig.INSANIUM_PICKAXE_OBSIDIAN) {
            tooltip.add(I18n.func_74838_a((String)"tooltip.mysticaladaptations.insanium_pickaxe"));
        }
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack);
        if (tag.func_74764_b("ToolType") && tag.func_74762_e("ToolType") == 1000) {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + Utils.localize((String)"tooltip.ma.mining_aoe"));
        } else {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + Tooltips.EMPTY);
        }
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        float aoeNerf = NBTHelper.getTagCompound((ItemStack)stack).func_74764_b("ToolType") ? (NBTHelper.getTagCompound((ItemStack)stack).func_74762_e("ToolType") == 1000 ? -15.0f : 0.0f) : 0.0f;
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e && material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) + aoeNerf : this.field_77864_a + aoeNerf;
    }

    public boolean func_150897_b(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return this.field_77862_b.func_77996_d() == 3;
        }
        if (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag) {
            if (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE) {
                if (block != Blocks.field_150340_R && block != Blocks.field_150352_o) {
                    if (block != Blocks.field_150339_S && block != Blocks.field_150366_p) {
                        if (block != Blocks.field_150368_y && block != Blocks.field_150369_x) {
                            if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) {
                                Material material = state.func_185904_a();
                                if (material == Material.field_151576_e) {
                                    return true;
                                }
                                if (material == Material.field_151573_f) {
                                    return true;
                                }
                                return material == Material.field_151574_g;
                            }
                            return this.field_77862_b.func_77996_d() >= 2;
                        }
                        return this.field_77862_b.func_77996_d() >= 1;
                    }
                    return this.field_77862_b.func_77996_d() >= 1;
                }
                return this.field_77862_b.func_77996_d() >= 2;
            }
            return this.field_77862_b.func_77996_d() >= 2;
        }
        return this.field_77862_b.func_77996_d() >= 2;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.INSANIUM_PAXEL && (tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == 1000) {
            boolean blocks = false;
            RayTraceResult ray = ToolTools.getBlockWithinReach((World)player.func_130014_f_(), (EntityPlayer)player);
            if (ray != null) {
                int side = ray.field_178784_b.ordinal();
                blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
            }
            return blocks;
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.getStrVsBlock(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE((ItemStack)stack, (World)world, (EntityPlayer)player, (BlockPos)pos);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (ModConfig.INSANIUM_PICKAXE_OBSIDIAN && OreDictionary.itemMatches((ItemStack)new ItemStack(Item.func_150898_a((Block)state.func_177230_c())), (ItemStack)new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z)), (boolean)false)) {
            return 9999.0f;
        }
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

