/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.items.insanium;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.util.ToolTools;
import com.blakebr0.mysticalagriculture.items.tools.ToolType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.init.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsaniumShovel
extends ItemSpade {
    public TextFormatting color;

    public InsaniumShovel(String name, Item.ToolMaterial material, TextFormatting color) {
        super(material);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAdaptations.tabMysticalAdaptations);
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.HOE_TOOLTIP[0] + " " + "\u00a77" + Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName() + " " + Tooltips.HOE_TOOLTIP[1] + " " + "\u00a75" + "3x3" + "\u00a77" + " " + Blocks.field_185774_da.func_149732_F() + ".");
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack);
        if (tag.func_74764_b("ToolType")) {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + ToolType.byIndex((int)tag.func_74762_e("ToolType")).getLocalizedName());
        } else {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a75" + Tooltips.EMPTY);
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.INSANIUM_SHOVEL && (tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == ToolType.MINING_AOE.getIndex()) {
            boolean blocks = false;
            RayTraceResult ray = ToolTools.getBlockWithinReach((World)player.func_130014_f_(), (EntityPlayer)player);
            if (ray != null) {
                int side = ray.field_178784_b.ordinal();
                blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
            }
            return blocks;
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f && state.func_177230_c().isToolEffective("shovel", state)) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    if (!aoeState.func_177230_c().isToolEffective("shovel", aoeState)) continue;
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.shovel(stack, player, world, pos, facing) && !player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1));
        if (player.func_70093_af()) {
            for (BlockPos aoePos : blocks) {
                this.shovel(stack, player, world, aoePos, facing);
            }
        } else {
            this.shovel(stack, player, world, pos, facing);
        }
        world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return EnumActionResult.SUCCESS;
    }

    private boolean shovel(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (!player.func_175151_a(pos.func_177972_a(face), face, stack)) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (face != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_185774_da)) {
            player.field_70170_p.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
            return true;
        }
        return false;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE((ItemStack)stack, (World)world, (EntityPlayer)player, (BlockPos)pos);
        }
        return false;
    }
}

