/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.lib;

import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.items.SeedExtractor;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipe;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipes;
import com.focamacho.mysticaladaptations.util.ModCheck;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCheck {
    public static ItemStack getSeedFromBlock(ItemStack extractor, ItemStack blockItem, Block block) {
        for (SeedExtractorRecipe recipe : SeedExtractorRecipes.allRecipes) {
            if (!BlockCheck.checkRecipe(recipe, extractor, blockItem, block)) continue;
            if (recipe.getType() != null && recipe.getType().isEnabled()) {
                return recipe.getSeed();
            }
            if (!ModCheck.MYSTICAL_AGRADDITIONS || recipe.getSeed() == null || recipe.getSeed().func_77973_b() == Items.field_190931_a) continue;
            return recipe.getSeed();
        }
        return null;
    }

    public static boolean checkTier(int tier, ItemStack extractor) {
        if (!(extractor.func_77973_b() instanceof SeedExtractor)) {
            return false;
        }
        if (!ModConfig.EXTRACTOR_ANY_TIER) {
            if (ModConfig.EXTRACTOR_LOWER_TIER) {
                return ((SeedExtractor)extractor.func_77973_b()).getExtractorTier() >= tier;
            }
            return ((SeedExtractor)extractor.func_77973_b()).getExtractorTier() == tier;
        }
        return true;
    }

    public static boolean checkRecipe(SeedExtractorRecipe recipe, ItemStack extractor, ItemStack blockItem, Block block) {
        return BlockCheck.checkBlock(blockItem, block, recipe.getItemsList(), recipe.getBlocksList()) && BlockCheck.checkTier(recipe.getTier(), extractor);
    }

    public static boolean checkBlock(ItemStack blockItem, Block block, List<ItemStack> itemList, List<Block> blockList) {
        block3: {
            block2: {
                if (itemList == null || itemList.isEmpty()) break block2;
                for (ItemStack b : itemList) {
                    if (!OreDictionary.itemMatches((ItemStack)b, (ItemStack)blockItem, (boolean)false)) continue;
                    return true;
                }
                break block3;
            }
            if (blockList == null || blockList.isEmpty()) break block3;
            for (Block b : blockList) {
                if (!Block.func_149680_a((Block)b, (Block)block)) continue;
                return true;
            }
        }
        return false;
    }
}

