/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.lib;

import com.blakebr0.mysticalagriculture.lib.CropType;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class SeedExtractorRecipe {
    private final List<ItemStack> itemList;
    private final List<Block> blockList;
    private final List<ResourceLocation> entityList;
    private final ItemStack seed;
    private final Integer tier;
    private CropType.Type type;

    public SeedExtractorRecipe(String[] config, CropType.Type seed) {
        this.itemList = SeedExtractorRecipe.getItemsFromConfig(config);
        this.blockList = SeedExtractorRecipe.getBlocksFromConfig(config);
        this.entityList = SeedExtractorRecipe.getEntitiesFromConfig(config);
        this.seed = new ItemStack((Item)seed.getSeed(), 1);
        this.tier = seed.getTier();
        this.type = seed;
        if (this.type.isEnabled()) {
            SeedExtractorRecipes.allRecipes.add(this);
        }
    }

    public SeedExtractorRecipe(String[] config, ItemStack seed, int tier) {
        this.itemList = SeedExtractorRecipe.getItemsFromConfig(config);
        this.blockList = SeedExtractorRecipe.getBlocksFromConfig(config);
        this.entityList = SeedExtractorRecipe.getEntitiesFromConfig(config);
        this.seed = seed;
        this.tier = tier;
        SeedExtractorRecipes.allRecipes.add(this);
    }

    private static List<ItemStack> getItemsFromConfig(String[] config) {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (String item : config) {
            ItemStack itemA;
            String[] split;
            if (item.startsWith("ore:")) {
                split = item.split(":");
                allItems.addAll(SeedExtractorRecipe.getItemListFromOredict(split[1]));
                continue;
            }
            if (item.startsWith("entity")) continue;
            split = item.split(":");
            if (split.length > 2) {
                itemA = new ItemStack(Item.func_111206_d((String)(split[0] + ":" + split[1])), 1, Integer.parseInt(split[2]));
                if (itemA.func_77973_b() == Items.field_190931_a) continue;
                allItems.add(itemA);
                continue;
            }
            if (split.length != 2 || (itemA = new ItemStack(Item.func_111206_d((String)(split[0] + ":" + split[1])))).func_77973_b() == Items.field_190931_a) continue;
            allItems.add(itemA);
        }
        return allItems;
    }

    private static List<ItemStack> getItemListFromOredict(String ore) {
        NonNullList oreItems = OreDictionary.getOres((String)ore);
        return oreItems;
    }

    private static List<Block> getBlocksFromConfig(String[] config) {
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        for (String block : config) {
            Block blockB;
            ItemStack blockA;
            if (block.startsWith("ore:") || block.startsWith("entity")) continue;
            String[] split = block.split(":");
            if (split.length > 2) {
                blockA = new ItemStack(Item.func_111206_d((String)(split[0] + ":" + split[1])), 1, Integer.parseInt(split[2]));
                if (blockA.func_77973_b() != Items.field_190931_a || (blockB = Block.func_149684_b((String)(split[0] + ":" + split[1]))) == null) continue;
                allBlocks.add(blockB);
                continue;
            }
            if (split.length != 2 || (blockA = new ItemStack(Item.func_111206_d((String)(split[0] + ":" + split[1])))).func_77973_b() != Items.field_190931_a || (blockB = Block.func_149684_b((String)(split[0] + ":" + split[1]))) == null) continue;
            allBlocks.add(blockB);
        }
        return allBlocks;
    }

    private static List<ResourceLocation> getEntitiesFromConfig(String[] config) {
        List entityRegistry = ForgeRegistries.ENTITIES.getValues();
        ArrayList<ResourceLocation> allEntities = new ArrayList<ResourceLocation>();
        for (String entity : config) {
            if (!entity.startsWith("entity")) continue;
            String[] split = entity.split(":");
            for (EntityEntry entityE : entityRegistry) {
                ResourceLocation entityR = new ResourceLocation(split[1] + ":" + split[2]);
                if (!entityE.getRegistryName().equals((Object)entityR)) continue;
                allEntities.add(entityR);
            }
        }
        return allEntities;
    }

    private List<ItemStack> removeAirFromList(ItemStack[] blockList) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemStack item : blockList) {
            if (item.func_77973_b() == Items.field_190931_a) continue;
            newList.add(item);
        }
        return newList;
    }

    public List<ItemStack> getItemsList() {
        return this.itemList;
    }

    public List<Block> getBlocksList() {
        return this.blockList;
    }

    public List<ResourceLocation> getEntitiesList() {
        return this.entityList;
    }

    public ItemStack getSeed() {
        return this.seed.func_77946_l();
    }

    public Integer getTier() {
        return this.tier;
    }

    public CropType.Type getType() {
        return this.type;
    }
}

