/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.util.compat.jei;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.lib.CropType;
import com.focamacho.mysticaladaptations.init.ModBlocks;
import com.focamacho.mysticaladaptations.init.ModItems;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipe;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipes;
import com.focamacho.mysticaladaptations.util.ModCheck;
import com.focamacho.mysticaladaptations.util.compat.jei.extractor.ExtractorItemStacks;
import com.focamacho.mysticaladaptations.util.compat.jei.extractor.ExtractorRecipe;
import com.focamacho.mysticaladaptations.util.compat.jei.extractor.ExtractorRecipeCategory;
import java.util.LinkedList;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        if (com.focamacho.mysticaladaptations.config.ModConfig.JEI_COMPAT) {
            registry.addRecipeCategories(new IRecipeCategory[]{new ExtractorRecipeCategory(jeiHelpers.getGuiHelper())});
        }
    }

    public void register(IModRegistry registry) {
        LinkedList<ExtractorRecipe> extractorRecipies = new LinkedList<ExtractorRecipe>();
        if (com.focamacho.mysticaladaptations.config.ModConfig.JEI_COMPAT && com.focamacho.mysticaladaptations.config.ModConfig.ENABLE_SEED_EXTRACTORS) {
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.INFERIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.PRUDENTIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.INTERMEDIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.SUPERIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.SUPREMIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            if (ModCheck.MYSTICAL_AGRADDITIONS) {
                registry.addRecipeCatalyst((Object)new ItemStack(ModItems.INSANIUM_SEED_EXTRACTOR), new String[]{"mysticaladaptations:extractor_jei"});
            }
            for (SeedExtractorRecipe recipe : SeedExtractorRecipes.allRecipes) {
                for (ItemStack item : ExtractorItemStacks.getItemStacks(recipe)) {
                    extractorRecipies.add(new ExtractorRecipe(recipe.getSeed(), item, recipe.getTier()));
                }
            }
            if (ModCheck.MYSTICAL_AGRADDITIONS && com.focamacho.mysticaladaptations.config.ModConfig.INSANIUM_REPROCESSOR && ModConfig.confSeedReprocessor) {
                registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INSANIUM_REPROCESSOR_BLOCK), new String[]{"mysticalagriculture:reprocessor_jei"});
            }
            if (com.focamacho.mysticaladaptations.config.ModConfig.EXPERIENCE_SEEDS_DROP) {
                registry.addIngredientInfo((Object)new ItemStack((Item)CropType.Type.EXPERIENCE.getSeed()), VanillaTypes.ITEM, new String[]{new TextComponentTranslation("jei.mysticaladaptations.experience_seeds_drop", new Object[0]).func_150254_d() + " " + (com.focamacho.mysticaladaptations.config.ModConfig.EXTRACTOR_ANY_TIER ? "1" : Integer.valueOf(CropType.Type.EXPERIENCE.getTier())) + " " + (!com.focamacho.mysticaladaptations.config.ModConfig.EXTRACTOR_LOWER_TIER ? "." : new TextComponentTranslation("jei.mysticaladaptations.experience_seeds_drop_higher", new Object[0]).func_150254_d()) + "\n\n" + new TextComponentTranslation("jei.mysticaladaptations.experience_seeds_drop_chance", new Object[0]).func_150254_d() + " " + com.focamacho.mysticaladaptations.config.ModConfig.EXPERIENCE_SEEDS_DROP_CHANCE + "%"});
            }
            registry.addRecipes(extractorRecipies, "mysticaladaptations:extractor_jei");
        }
    }
}

