/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.util.handlers;

import com.blakebr0.mysticalagriculture.lib.CropType;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.init.ModRecipes;
import com.focamacho.mysticaladaptations.util.DummyRecipe;
import com.focamacho.mysticaladaptations.util.ModCheck;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CraftingHandler {
    public static final List<Item> seedItems = CraftingHandler.getAllSeedItems();
    public static final List<Item> recipeWhitelist = CraftingHandler.getAllWhitelistRecipes();

    public static void removeRecipes() {
        if (ModConfig.REMOVE_SEED_RECIPES || ModConfig.REMOVE_MOBS_SEED_RECIPES) {
            ForgeRegistry recipeRegistry = (ForgeRegistry)ForgeRegistries.RECIPES;
            ArrayList recipes = Lists.newArrayList((Iterable)recipeRegistry.getValuesCollection());
            for (IRecipe r : recipes) {
                Item output = r.func_77571_b().func_77973_b();
                if (recipeWhitelist.contains(output)) continue;
                for (Item seed : seedItems) {
                    if (output != seed) continue;
                    recipeRegistry.remove(r.getRegistryName());
                    recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(r));
                }
            }
            if (ModCheck.MYSTICAL_AGRADDITIONS && ModConfig.REMOVE_AGRADDITIONS_RECIPES) {
                ResourceLocation[] seedsAgradditions;
                for (ResourceLocation resource : seedsAgradditions = new ResourceLocation[]{new ResourceLocation("mysticalagradditions:nether_star_seeds"), new ResourceLocation("mysticalagradditions:awakened_draconium_seeds"), new ResourceLocation("mysticalagradditions:dragon_egg_seeds"), new ResourceLocation("mysticalagradditions:neutronium_seeds")}) {
                    IRecipe recipe;
                    if (recipeRegistry.getValue(resource) == null || (recipe = (IRecipe)recipeRegistry.getValue(resource)) == null) continue;
                    recipeRegistry.remove(recipe.getRegistryName());
                    recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(recipe));
                }
            }
        }
    }

    public static List<Item> getAllSeedItems() {
        ArrayList<Item> seedItems = new ArrayList<Item>();
        for (CropType.Type type : CropType.Type.values()) {
            seedItems.add((Item)type.getSeed());
        }
        return seedItems;
    }

    public static List<Item> getAllWhitelistRecipes() {
        ArrayList<Item> recipeWhitelist = new ArrayList<Item>();
        if (ModConfig.REMOVE_SEED_RECIPES && ModConfig.REMOVE_MOBS_SEED_RECIPES) {
            return recipeWhitelist;
        }
        if (!ModConfig.REMOVE_SEED_RECIPES) {
            for (CropType.Type type : CropType.Type.values()) {
                if (CraftingHandler.isMobType(type)) continue;
                recipeWhitelist.add((Item)type.getSeed());
            }
        }
        if (!ModConfig.REMOVE_MOBS_SEED_RECIPES) {
            for (CropType.Type type : CropType.Type.values()) {
                if (!CraftingHandler.isMobType(type)) continue;
                recipeWhitelist.add((Item)type.getSeed());
            }
        }
        return recipeWhitelist;
    }

    public static boolean isMobType(CropType.Type seedType) {
        CropType.Type[] types;
        for (CropType.Type type : types = new CropType.Type[]{CropType.Type.BASALZ, CropType.Type.BLAZE, CropType.Type.BLITZ, CropType.Type.BLIZZ, CropType.Type.CHICKEN, CropType.Type.COW, CropType.Type.CREEPER, CropType.Type.ENDERMAN, CropType.Type.GHAST, CropType.Type.GUARDIAN, CropType.Type.PIG, CropType.Type.RABBIT, CropType.Type.SHEEP, CropType.Type.SKELETON, CropType.Type.SPIDER, CropType.Type.WITHER_SKELETON, CropType.Type.ZOMBIE, CropType.Type.SLIME}) {
            if (!seedType.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void recipes(RegistryEvent.Register<IRecipe> e) {
        ModRecipes.initRecipes();
    }
}

