/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.util.handlers;

import com.blakebr0.mysticalagriculture.lib.CropType;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.items.SeedExtractor;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipe;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipes;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDropsHandler {
    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        if (event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack weapon = ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof SeedExtractor) {
                Random random;
                if (ModConfig.MOB_SEED_DROP) {
                    for (SeedExtractorRecipe recipe : SeedExtractorRecipes.allRecipes) {
                        if (!this.checkRecipe(event.getEntityLiving(), recipe, weapon)) continue;
                        this.dropItem(event, recipe.getSeed(), weapon, (EntityLivingBase)player);
                    }
                }
                if (ModConfig.EXPERIENCE_SEEDS_DROP && CropType.Type.EXPERIENCE.isEnabled() && (random = new Random()).nextInt(100) <= ModConfig.EXPERIENCE_SEEDS_DROP_CHANCE) {
                    if (ModConfig.EXPERIENCE_SEEDS_DROP_DURABILITY) {
                        this.dropItem(event, new ItemStack((Item)CropType.Type.EXPERIENCE.getSeed(), 1), weapon, (EntityLivingBase)player);
                    } else {
                        this.dropItem(event, new ItemStack((Item)CropType.Type.EXPERIENCE.getSeed(), 1));
                    }
                }
            }
        }
    }

    public boolean checkRecipe(EntityLivingBase entity, SeedExtractorRecipe recipe, ItemStack extractor) {
        return this.checkEntity(entity, recipe.getEntitiesList()) && MobDropsHandler.checkTier(recipe.getTier(), extractor);
    }

    public boolean checkEntity(EntityLivingBase entity, List<ResourceLocation> resourceList) {
        if (resourceList != null && !resourceList.isEmpty()) {
            for (ResourceLocation r : resourceList) {
                ResourceLocation entityR = EntityList.func_191301_a((Entity)entity);
                if (entityR == null || !entityR.equals((Object)r)) continue;
                return true;
            }
        }
        return false;
    }

    public void dropItem(LivingDropsEvent event, ItemStack drop, ItemStack extractor, EntityLivingBase player) {
        EntityItem entityItem = new EntityItem(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, drop);
        event.getDrops().add(entityItem);
        extractor.func_77972_a(1, player);
    }

    public void dropItem(LivingDropsEvent event, ItemStack drop) {
        EntityItem entityItem = new EntityItem(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, drop);
        event.getDrops().add(entityItem);
    }

    public static boolean checkTier(int tier, ItemStack extractor) {
        if (!(extractor.func_77973_b() instanceof SeedExtractor)) {
            return false;
        }
        if (!ModConfig.EXTRACTOR_ANY_TIER) {
            if (ModConfig.EXTRACTOR_LOWER_TIER) {
                return ((SeedExtractor)extractor.func_77973_b()).getExtractorTier() >= tier;
            }
            return ((SeedExtractor)extractor.func_77973_b()).getExtractorTier() == tier;
        }
        return true;
    }
}

