/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.util.handlers;

import com.focamacho.mysticaladaptations.MysticalAdaptations;
import com.focamacho.mysticaladaptations.config.ModConfig;
import com.focamacho.mysticaladaptations.config.RecipesConfig;
import com.focamacho.mysticaladaptations.init.ModBlocks;
import com.focamacho.mysticaladaptations.init.ModEntities;
import com.focamacho.mysticaladaptations.init.ModItems;
import com.focamacho.mysticaladaptations.init.ModTileEntities;
import com.focamacho.mysticaladaptations.items.insanium.InsaniumArmor;
import com.focamacho.mysticaladaptations.lib.SeedExtractorRecipes;
import com.focamacho.mysticaladaptations.util.ModCheck;
import com.focamacho.mysticaladaptations.util.compat.crafttweaker.CompatCT;
import com.focamacho.mysticaladaptations.util.compat.tconstruct.CompatTConstruct;
import com.focamacho.mysticaladaptations.util.handlers.CraftingHandler;
import com.focamacho.mysticaladaptations.util.handlers.MobDropsHandler;
import com.focamacho.mysticaladaptations.util.handlers.TooltipsHandler;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        ModItems.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        ModBlocks.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
        ModTileEntities.init();
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            MysticalAdaptations.proxy.registerItemRenderer(item, 0, "inventory");
        }
        for (Block block : ModBlocks.BLOCKS) {
            MysticalAdaptations.proxy.registerItemRenderer(Item.func_150898_a((Block)block), 0, "inventory");
        }
    }

    public static void preInitRegistries(FMLPreInitializationEvent event) {
        ModConfig.init(new File(event.getModConfigurationDirectory(), "mysticaladaptations.cfg"));
        RecipesConfig.init(new File(event.getModConfigurationDirectory(), "mysticaladaptations_recipes.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
        if (ModCheck.MYSTICAL_AGRADDITIONS) {
            if (ModConfig.INSANIUM_ARMOR || ModConfig.INSANIUM_TOOLS) {
                MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
            }
            if (ModConfig.INSANIUM_TOOLS) {
                ModEntities.init();
            }
            if (ModCheck.TCONSTRUCT && ModConfig.TINKERS_INSANIUM) {
                CompatTConstruct.init();
            }
        }
        if (ModCheck.CRAFTTWEAKER) {
            CompatCT.preInit();
        }
    }

    public static void initRegistries() {
        if (ModConfig.NETHERSTARS_BLOCK) {
            OreDictionary.registerOre((String)"blockNetherStar", (Block)ModBlocks.NETHERSTAR_BLOCK);
        }
        if (ModConfig.SILICON_BLOCK) {
            OreDictionary.registerOre((String)"blockSilicon", (Block)ModBlocks.SILICON_BLOCK);
        }
        if (ModConfig.HOP_GRAPHITE_BLOCK) {
            OreDictionary.registerOre((String)"blockHOPGraphite", (Block)ModBlocks.HOP_GRAPHITE_BLOCK);
        }
        if (ModConfig.ENABLE_SEED_EXTRACTORS) {
            SeedExtractorRecipes.init();
        }
        if (ModConfig.MOB_SEED_DROP) {
            MinecraftForge.EVENT_BUS.register((Object)new MobDropsHandler());
        }
        if (ModCheck.MYSTICAL_AGRADDITIONS) {
            if (ModConfig.INSANIUM_TOOLS) {
                MinecraftForge.EVENT_BUS.register((Object)new TooltipsHandler());
            }
            if (ModConfig.INSANIUM_ARMOR) {
                MinecraftForge.EVENT_BUS.register((Object)new InsaniumArmor.AbilityHandler());
            }
            if (ModCheck.TCONSTRUCT && ModConfig.TINKERS_INSANIUM) {
                CompatTConstruct.initRecipes();
            }
        }
        if (ModCheck.CRAFTTWEAKER) {
            CompatCT.init();
        }
    }

    public static void postInitRegistries() {
        CraftingHandler.removeRecipes();
    }
}

