/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.melter.blocks.BlockMelter;
import knightminer.tcomplement.melter.tileentity.TileAlloyTank;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class BlockAlloyTank
extends Block
implements ITileEntityProvider,
IFaucetDepth {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private BlockMelter melter;
    private Block tank;

    public BlockAlloyTank(BlockMelter melter, Block tank) {
        super(Material.field_151576_e);
        this.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.melter = melter;
        this.tank = tank;
    }

    public boolean isHeater(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this.tank || block == this.melter && state.func_177229_b(BlockMelter.TYPE) == BlockMelter.MelterType.HEATER;
    }

    public boolean isTank(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this.tank || block == this.melter && state.func_177229_b(BlockMelter.TYPE) == BlockMelter.MelterType.MELTER;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileAlloyTank();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        BlockAlloyTank.updatePower(state, world, pos);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockAlloyTank.updatePower(state, world, pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAlloyTank) {
            ((TileAlloyTank)te).checkTanks();
        }
    }

    private static void updatePower(IBlockState state, World world, BlockPos pos) {
        boolean powered = world.func_175640_z(pos);
        if (powered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)), 4);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (Util.onFluidTankActivated(world, pos, player, hand, facing)) {
            return true;
        }
        return FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAlloyTank) {
            TileAlloyTank alloyer = (TileAlloyTank)te;
            if (!stack.func_190926_b() && stack.func_77942_o()) {
                alloyer.readTankFromNBT(stack.func_77978_p());
            }
            alloyer.checkTanks();
        }
    }

    @Nonnull
    @Deprecated
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity te;
        ArrayList ret = Lists.newArrayList();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        Item item = this.func_180660_a(state, rand, fortune);
        ItemStack stack = ItemStack.field_190927_a;
        if (item != Items.field_190931_a) {
            stack = new ItemStack(item, 1, this.func_180651_a(state));
            ret.add(stack);
        }
        if ((te = world.func_175625_s(pos)) instanceof TileTank && !stack.func_190926_b() && ((TileTank)te).containsFluid()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileTank)te).writeTankToNBT(tag);
            stack.func_77982_d(tag);
        }
        return ret;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        TileTank tank = (TileTank)te;
        return tank.getBrightness();
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAlloyTank && ((TileAlloyTank)te).isActive()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5;
            double z = (double)pos.func_177952_p() + 0.5;
            double front = 0.52;
            double side = rand.nextDouble() * 0.8 - 0.4;
            double top = rand.nextDouble() * 0.8 - 0.4;
            switch (rand.nextInt(5)) {
                case 0: {
                    BlockAlloyTank.spawnFireParticle(world, x - front, y + top, z + side);
                    break;
                }
                case 1: {
                    BlockAlloyTank.spawnFireParticle(world, x + front, y + top, z + side);
                    break;
                }
                case 2: {
                    BlockAlloyTank.spawnFireParticle(world, x + side, y + top, z - front);
                    break;
                }
                case 3: {
                    BlockAlloyTank.spawnFireParticle(world, x + side, y + top, z + front);
                    break;
                }
                case 4: {
                    BlockAlloyTank.spawnFireParticle(world, x + side, y + front, z + top);
                }
            }
        }
    }

    private static void spawnFireParticle(World world, double x, double y, double z) {
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        return ((TileTank)te).comparatorStrength();
    }

    public float getFlowDepth(World world, BlockPos pos, IBlockState state) {
        return 1.0f;
    }
}

