/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.melter.inventory.ContainerMelter;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.client.GuiHeatingStructureFuelTank;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;

public class GuiMelter
extends GuiHeatingStructureFuelTank
implements IGuiLiquidTank {
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/melter.png");
    public static final ResourceLocation BACKGROUND_SOLID = Util.getResource("textures/gui/melter_solid.png");
    protected GuiElement scala = new GuiElement(176, 0, 52, 52, 256, 256);
    protected GuiElement progressBar = new GuiElementScalable(176, 150, 3, 16, 256, 256);
    protected GuiElement unprogressBar = new GuiElementScalable(179, 150, 3, 16);
    protected GuiElement uberHeatBar = new GuiElementScalable(182, 150, 3, 16);
    protected GuiElement noMeltBar = new GuiElementScalable(185, 150, 3, 16);
    protected GuiElement flame = new GuiElementScalable(176, 52, 14, 14);
    public TileMelter melter;
    private boolean solidFuel;
    private ResourceLocation background;

    public GuiMelter(ContainerMelter container, TileMelter melter) {
        super((ContainerMultiModule)container);
        this.melter = melter;
        this.background = BACKGROUND;
        boolean bl = this.solidFuel = melter.getSolidHeater() != null;
        if (this.solidFuel) {
            this.background = BACKGROUND_SOLID;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.melter.getSolidHeater() != null != this.solidFuel) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int yMax;
        super.func_146979_b(mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scala.draw(90, 16);
        mouseX -= this.cornerX;
        mouseY -= this.cornerY;
        RenderHelper.func_74518_a();
        String tooltipText = null;
        if (this.field_147002_h instanceof ContainerMelter) {
            for (Slot slot : ((ContainerMelter)this.field_147002_h).getInventorySlots()) {
                if (!slot.func_75216_d()) continue;
                float progress = this.melter.getHeatingProgress(slot.getSlotIndex());
                String tooltip = null;
                GuiElement bar = this.progressBar;
                if (Float.isNaN(progress)) {
                    progress = 1.0f;
                    bar = this.noMeltBar;
                    tooltip = "gui.smeltery.progress.no_recipe";
                } else if (progress < 0.0f) {
                    bar = this.unprogressBar;
                    progress = 1.0f;
                    tooltip = "gui.smeltery.progress.no_heat";
                } else if (progress > 1.0f && progress < 2.0f || progress == Float.POSITIVE_INFINITY) {
                    progress = 1.0f;
                } else if (progress >= 2.0f && progress < 3.0f) {
                    bar = this.uberHeatBar;
                    progress = 1.0f;
                    tooltip = "gui.tcomplement.melter.progress.no_space";
                } else if (progress >= 3.0f) {
                    bar = this.uberHeatBar;
                    progress = 1.0f;
                    tooltip = "gui.tcomplement.melter.progress.wrong_fluid";
                }
                int height = 1 + Math.round(progress * (float)(bar.h - 1));
                int x = slot.field_75223_e - 4;
                int y = slot.field_75221_f + bar.h - height;
                if (tooltip != null && x <= mouseX && x + bar.w > mouseX && y <= mouseY && y + bar.h > mouseY) {
                    tooltipText = tooltip;
                }
                GuiScreen.func_146110_a((int)x, (int)y, (float)bar.x, (float)(bar.y + bar.h - height), (int)bar.w, (int)height, (float)bar.texW, (float)bar.texH);
            }
        }
        if (tooltipText != null) {
            this.func_146283_a(this.field_146289_q.func_78271_c(Util.translate(tooltipText, new Object[0]), 100), mouseX, mouseY);
        }
        this.drawTankTooltip(mouseX, mouseY);
        int xMin = 153;
        int xMax = this.solidFuel ? 167 : 165;
        int yMin = this.solidFuel ? 36 : 16;
        int n = yMax = this.solidFuel ? 50 : 68;
        if (xMin <= mouseX && mouseX < xMax && yMin <= mouseY && mouseY < yMax) {
            if (this.melter.currentFuel != null) {
                this.drawFuelTooltip(mouseX, mouseY);
            } else {
                this.drawSolidFuelTooltip(mouseX, mouseY);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(this.background);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawTank(90, 16, 52, 52);
        this.fuelInfo = this.melter.getFuelDisplay();
        if (this.solidFuel) {
            float fuel = this.melter.getFuelPercentage();
            if (fuel > 0.0f) {
                this.field_146297_k.func_110434_K().func_110577_a(this.background);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiElement flame = this.flame;
                int height = 1 + Math.round(fuel * (float)(flame.h - 1));
                int x = 153 + this.cornerX;
                int y = 36 + this.cornerY + flame.h - height;
                GuiScreen.func_146110_a((int)x, (int)y, (float)flame.x, (float)(flame.y + flame.h - height), (int)flame.w, (int)height, (float)flame.texW, (float)flame.texH);
            }
        } else {
            this.drawFuel(153, 16, 12, 52);
        }
    }

    protected FluidStack getHoveredFluidStack(int x, int y) {
        FluidTankAnimated tank = this.melter.getTank();
        FluidStack fluid = tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            int h = 52 - 52 * fluid.amount / tank.getCapacity();
            if (x >= 90 && x < 142 && y >= h + 16 && y < 68) {
                return fluid;
            }
        }
        return null;
    }

    public FluidStack getFluidStackAtPosition(int x, int y) {
        return this.getHoveredFluidStack(x - this.cornerX, y - this.cornerY);
    }

    protected void drawTank(int displayX, int displayY, int width, int height) {
        FluidTankAnimated tank = this.melter.getTank();
        FluidStack fluid = tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            int x = displayX + this.cornerX;
            int y = displayY + this.cornerY + height;
            int w = width;
            int h = height * fluid.amount / tank.getCapacity();
            GuiUtil.renderTiledFluid((int)x, (int)(y - h), (int)w, (int)h, (float)this.field_73735_i, (FluidStack)fluid);
        }
    }

    protected void drawTankTooltip(int x, int y) {
        List<String> tooltip = this.getTankTooltip(x, y);
        if (tooltip != null) {
            this.func_146283_a(tooltip, x, y);
        }
    }

    protected List<String> getTankTooltip(int x, int y) {
        if (x >= 90 && x < 142 && y >= 16 && y < 68) {
            Consumer<Integer> stringFn;
            FluidTankAnimated tank = this.melter.getTank();
            FluidStack hovered = this.getHoveredFluidStack(x, y);
            ArrayList text = Lists.newArrayList();
            Consumer<Integer> consumer = stringFn = Util.isShiftKeyDown() ? i -> GuiUtil.amountToString((int)i, (List)text) : i -> GuiUtil.amountToIngotString((int)i, (List)text);
            if (hovered == null) {
                int usedCap = tank.getFluidAmount();
                int maxCap = tank.getCapacity();
                text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.capacity", new Object[0]));
                stringFn.accept(maxCap);
                text.add(Util.translateFormatted("gui.smeltery.capacity_available", new Object[0]));
                stringFn.accept(maxCap - usedCap);
                text.add(Util.translateFormatted("gui.smeltery.capacity_used", new Object[0]));
                stringFn.accept(usedCap);
                if (!Util.isShiftKeyDown()) {
                    text.add("");
                    text.add(Util.translate("tooltip.tank.holdShift", new Object[0]));
                }
            } else {
                text.add(TextFormatting.WHITE + hovered.getLocalizedName());
                GuiUtil.liquidToString((FluidStack)hovered, (List)text);
            }
            return text;
        }
        return null;
    }

    protected void drawSolidFuelTooltip(int mouseX, int mouseY) {
        ArrayList text = Lists.newArrayList();
        text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.fuel", new Object[0]));
        if (this.melter.hasFuel()) {
            text.add(Util.translate("gui.tcomplement.melter.solid_fuel", new Object[0]));
            text.add(TextFormatting.GRAY + Util.translateFormatted("gui.tcomplement.melter.solid_fuel.amount", this.melter.getFuel() / 5));
            text.add(Util.translateFormatted("gui.smeltery.fuel.heat", Util.celsiusString(this.melter.getTemperature())));
        } else {
            text.add(Util.translate("gui.smeltery.fuel.empty", new Object[0]));
        }
        this.func_146283_a(text, mouseX, mouseY);
    }
}

