/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.inventory;

import knightminer.tcomplement.melter.inventory.SlotHeaterFuel;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import slimeknights.mantle.inventory.ContainerMultiModule;

public class ContainerMelter
extends ContainerMultiModule<TileMelter> {
    protected int[] oldHeats;
    protected int inventorySize;
    protected int oldFuel;
    protected int oldFuelQuality;
    private Slot[] slots;

    public ContainerMelter(InventoryPlayer inventoryPlayer, TileMelter tile) {
        super((TileEntity)tile);
        TileHeater heater = tile.getSolidHeater();
        if (heater != null) {
            this.func_75146_a((Slot)new SlotHeaterFuel((IItemHandler)heater.getItemHandler(), 0, 152, 52));
        }
        this.slots = new Slot[3];
        for (int i = 0; i < 3; ++i) {
            HeaterSlot slot = new HeaterSlot(this.itemHandler, i, 22, 16 + i * 18);
            this.func_75146_a((Slot)slot);
            this.slots[i] = slot;
        }
        this.addPlayerInventory(inventoryPlayer, 8, 84);
        this.inventorySize = this.slots.length;
        this.oldHeats = new int[this.inventorySize];
        this.oldFuel = 0;
        this.oldFuelQuality = 0;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, ((TileMelter)this.tile).getFuel());
        listener.func_71112_a((Container)this, 1, ((TileMelter)this.tile).fuelQuality);
        for (int i = 0; i < this.inventorySize; ++i) {
            listener.func_71112_a((Container)this, i + 2, ((TileMelter)this.tile).getTemperature(i));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        int fuel = ((TileMelter)this.tile).getFuel();
        if (fuel != this.oldFuel) {
            this.oldFuel = fuel;
            this.sendUpdate(0, fuel);
        }
        if ((fuel = ((TileMelter)this.tile).fuelQuality) != this.oldFuelQuality) {
            this.oldFuelQuality = fuel;
            this.sendUpdate(1, fuel);
        }
        for (int i = 0; i < this.inventorySize; ++i) {
            int temp = ((TileMelter)this.tile).getTemperature(i);
            if (temp == this.oldHeats[i]) continue;
            this.oldHeats[i] = temp;
            this.sendUpdate(i + 2, temp);
        }
    }

    private void sendUpdate(int index, int update) {
        for (IContainerListener crafter : this.field_75149_d) {
            crafter.func_71112_a((Container)this, index, update);
        }
    }

    public void func_75137_b(int id, int data) {
        if (id < 2) {
            ((TileMelter)this.tile).updateFuelFromPacket(id, data);
        } else if (id < this.inventorySize + 2) {
            ((TileMelter)this.tile).updateTemperatureFromPacket(id - 2, data);
        }
    }

    public Slot[] getInventorySlots() {
        return this.slots;
    }

    private static class HeaterSlot
    extends SlotItemHandler {
        public HeaterSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return true;
        }

        public int func_178170_b(ItemStack stack) {
            return 1;
        }
    }
}

