/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.steelworks.HeatRecipe;
import knightminer.tcomplement.library.steelworks.HighOvenFuel;
import knightminer.tcomplement.melter.MelterModule;
import knightminer.tcomplement.melter.client.GuiMelter;
import knightminer.tcomplement.plugin.ceramics.CeramicsPlugin;
import knightminer.tcomplement.plugin.chisel.ChiselPlugin;
import knightminer.tcomplement.plugin.exnihilo.ExNihiloPlugin;
import knightminer.tcomplement.plugin.jei.MeltingRecipeGetter;
import knightminer.tcomplement.plugin.jei.highoven.fuel.HighOvenFuelCategory;
import knightminer.tcomplement.plugin.jei.highoven.fuel.HighOvenFuelGetter;
import knightminer.tcomplement.plugin.jei.highoven.fuel.HighOvenFuelWrapper;
import knightminer.tcomplement.plugin.jei.highoven.heat.HighOvenHeatCategory;
import knightminer.tcomplement.plugin.jei.highoven.heat.HighOvenHeatGetter;
import knightminer.tcomplement.plugin.jei.highoven.heat.HighOvenHeatWrapper;
import knightminer.tcomplement.plugin.jei.highoven.melting.HighOvenMeltingCategory;
import knightminer.tcomplement.plugin.jei.highoven.melting.HighOvenMeltingWrapper;
import knightminer.tcomplement.plugin.jei.highoven.mix.HighOvenMixCategory;
import knightminer.tcomplement.plugin.jei.highoven.mix.HighOvenMixGetter;
import knightminer.tcomplement.plugin.jei.highoven.mix.HighOvenMixWrapper;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeCategory;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeWrapper;
import knightminer.tcomplement.shared.CommonsModule;
import knightminer.tcomplement.steelworks.SteelworksModule;
import knightminer.tcomplement.steelworks.client.GuiHighOven;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeChecker;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;
import slimeknights.tconstruct.tools.TinkerMaterials;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    private static final String FURNACE_FUEL = "minecraft.fuel";
    private static final String TINKERS_SMELTERY = "tconstruct.smeltery";
    private static final String TINKERS_ALLOYING = "tconstruct.alloy";
    private static final String EXNIHILO_HAMMER = "exnihilocreatio:hammer";
    private static final String CHISEL_CHISELING = "chisel.chiseling";
    public static MeltingRecipeCategory meltingCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        if (Config.jei.separateMelterTab && PulseBase.isMelterLoaded()) {
            IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
            meltingCategory = new MeltingRecipeCategory(guiHelper);
            iRecipeCategoryArray[0] = meltingCategory;
            registry.addRecipeCategories(iRecipeCategoryArray);
        }
        if (PulseBase.isSteelworksLoaded()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HighOvenMixCategory(guiHelper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new HighOvenHeatCategory(guiHelper)});
            if (Config.jei.separateHighOvenTab) {
                registry.addRecipeCategories(new IRecipeCategory[]{new HighOvenMeltingCategory(guiHelper)});
            }
            if (Config.jei.showHighOvenFuel) {
                registry.addRecipeCategories(new IRecipeCategory[]{new HighOvenFuelCategory(guiHelper)});
            }
        }
    }

    public void register(IModRegistry registry) {
        List smelteryRecipes = null;
        if (PulseBase.isMelterLoaded()) {
            String melterCategory = TINKERS_SMELTERY;
            if (Config.jei.separateMelterTab) {
                melterCategory = MeltingRecipeCategory.CATEGORY;
                smelteryRecipes = SmeltingRecipeChecker.getSmeltingRecipes();
                registry.handleRecipes(MeltingRecipe.class, MeltingRecipeWrapper::new, MeltingRecipeCategory.CATEGORY);
                registry.addRecipes(MeltingRecipeGetter.getMelterRecipes(smelteryRecipes), MeltingRecipeCategory.CATEGORY);
            }
            if (MelterModule.melter != null) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.melter), new String[]{melterCategory});
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.melter, 1, 8), new String[]{FURNACE_FUEL});
            }
            if (MelterModule.porcelainMelter != null) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.porcelainMelter), new String[]{melterCategory});
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.porcelainMelter, 1, 8), new String[]{FURNACE_FUEL});
            }
            if (MelterModule.alloyTank != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(MelterModule.alloyTank), new String[]{TINKERS_ALLOYING});
            }
            if (MelterModule.porcelainAlloyTank != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(MelterModule.porcelainAlloyTank), new String[]{TINKERS_ALLOYING});
            }
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiMelter>(GuiMelter.class)});
        }
        if (PulseBase.isSteelworksLoaded()) {
            BlockCasting.CastingType[] guiHelper = registry.getJeiHelpers().getGuiHelper();
            String highOvenMelting = TINKERS_SMELTERY;
            if (smelteryRecipes == null) {
                smelteryRecipes = SmeltingRecipeChecker.getSmeltingRecipes();
            }
            List<MeltingRecipe> highOvenMeltingRecipes = MeltingRecipeGetter.getHighOvenRecipes(smelteryRecipes);
            if (Config.jei.separateHighOvenTab) {
                highOvenMelting = HighOvenMeltingCategory.CATEGORY;
                registry.handleRecipes(MeltingRecipe.class, HighOvenMeltingWrapper::new, highOvenMelting);
                registry.addRecipes(highOvenMeltingRecipes, highOvenMelting);
            }
            registry.handleRecipes(HighOvenMixWrapper.class, r -> r, HighOvenMixCategory.CATEGORY);
            registry.addRecipes(HighOvenMixGetter.getMixRecipes(highOvenMeltingRecipes), HighOvenMixCategory.CATEGORY);
            registry.handleRecipes(HeatRecipe.class, HighOvenHeatWrapper::new, HighOvenHeatCategory.CATEGORY);
            registry.addRecipes(HighOvenHeatGetter.getHeatRecipes(), HighOvenHeatCategory.CATEGORY);
            if (Config.jei.showHighOvenFuel) {
                registry.handleRecipes(HighOvenFuel.class, arg_0 -> JEIPlugin.lambda$register$1((IGuiHelper)guiHelper, arg_0), HighOvenFuelCategory.CATEGORY);
                registry.addRecipes(HighOvenFuelGetter.getHighOvenFuels(), HighOvenFuelCategory.CATEGORY);
            }
            registry.addRecipeCatalyst((Object)new ItemStack((Block)SteelworksModule.highOvenController), new String[]{highOvenMelting, HighOvenMixCategory.CATEGORY, HighOvenHeatCategory.CATEGORY});
            if (Config.jei.showHighOvenFuel) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)SteelworksModule.highOvenController), new String[]{HighOvenFuelCategory.CATEGORY});
            }
            for (BlockCasting.CastingType type : BlockCasting.CastingType.values()) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)SteelworksModule.scorchedCasting, 1, type.getMeta()), new String[]{CastingRecipeCategory.CATEGORY});
            }
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiHighOven>(GuiHighOven.class)});
        }
        if (PulseBase.isCeramicsPluginLoaded()) {
            for (BlockCasting.CastingType type : BlockCasting.CastingType.values()) {
                registry.addRecipeCatalyst((Object)new ItemStack(CeramicsPlugin.porcelainCasting, 1, type.getMeta()), new String[]{CastingRecipeCategory.CATEGORY});
            }
        }
        if (ChiselPlugin.chisel != null) {
            registry.addRecipeCatalyst((Object)ChiselPlugin.chisel.buildItem((List)ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.iron)), new String[]{CHISEL_CHISELING});
        }
        if (ExNihiloPlugin.sledgeHammer != null) {
            registry.addRecipeCatalyst((Object)ExNihiloPlugin.sledgeHammer.buildItem((List)ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.iron, (Object)TinkerMaterials.paper)), new String[]{EXNIHILO_HAMMER});
        }
        if (Config.general.chocolate) {
            IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
            JEIPlugin.blacklistFluid(blacklist, CommonsModule.chocolateLiquor);
            JEIPlugin.blacklistFluid(blacklist, CommonsModule.milkChocolate);
            blacklist.addIngredientToBlacklist((Object)CommonsModule.milkChocolateIngot);
            blacklist.addIngredientToBlacklist((Object)CommonsModule.milkChocolateNugget);
            blacklist.addIngredientToBlacklist((Object)CommonsModule.cocoaButter);
            if (PulseBase.isSteelworksLoaded()) {
                JEIPlugin.blacklistFluid(blacklist, CommonsModule.darkChocolate);
                blacklist.addIngredientToBlacklist((Object)CommonsModule.cocoaButter);
                blacklist.addIngredientToBlacklist((Object)CommonsModule.darkChocolateIngot);
                blacklist.addIngredientToBlacklist((Object)CommonsModule.darkChocolateNugget);
            }
        }
    }

    private static void blacklistFluid(IIngredientBlacklist blacklist, Fluid fluid) {
        FluidStack stack = new FluidStack(fluid, 1000);
        blacklist.addIngredientToBlacklist((Object)stack);
        blacklist.addIngredientToBlacklist((Object)FluidUtil.getFilledBucket((FluidStack)stack));
    }

    private static /* synthetic */ IRecipeWrapper lambda$register$1(IGuiHelper guiHelper, HighOvenFuel fuel) {
        return new HighOvenFuelWrapper(fuel, guiHelper);
    }

    private static class TinkerGuiTankHandler<T extends GuiContainer>
    implements IAdvancedGuiHandler<T> {
        private Class<T> clazz;

        public TinkerGuiTankHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public Class<T> getGuiContainerClass() {
            return this.clazz;
        }

        @Nullable
        public Object getIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
            return ((IGuiLiquidTank)guiContainer).getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

