/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei.melter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.GuiUtil;

public class MeltingRecipeCategory
implements IRecipeCategory<MeltingRecipeWrapper> {
    public static final String CATEGORY = Util.resource("melter");
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/jei/melter.png");
    private static List<ItemStack> furnaceFuels;
    private final IDrawable background;
    private final IDrawable scala;
    protected final IDrawable solidCover;
    protected final IDrawableAnimated flame;
    private final IDrawableAnimated progress;

    public MeltingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 160, 46, 0, 0, 0, 0);
        this.solidCover = guiHelper.createDrawable(BACKGROUND, 174, 0, 18, 33);
        this.scala = guiHelper.createDrawable(BACKGROUND, 192, 0, 32, 32);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(BACKGROUND, 160, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic progressDrawable = guiHelper.createDrawable(BACKGROUND, 160, 14, 3, 16);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return Util.translate("gui.jei.melter.title", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progress.draw(minecraft, 49, 21);
    }

    public void setRecipe(IRecipeLayout recipeLayout, MeltingRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        items.init(0, true, 52, 20);
        items.set(ingredients);
        if (recipe.isSolid) {
            items.init(1, true, 6, 22);
            items.set(1, MeltingRecipeCategory.getFurnaceFuels());
        }
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        fluids.addTooltipCallback(GuiUtil::onFluidTooltip);
        fluids.init(0, false, 121, 7, 32, 32, 1296, false, this.scala);
        fluids.set(ingredients);
        fluids.init(1, true, 29, 7, 12, 32, 1000, false, null);
        fluids.set(1, recipe.getLiquidFuels());
    }

    public String getModName() {
        return "Tinkers' Complement";
    }

    private static List<ItemStack> getFurnaceFuels() {
        if (furnaceFuels != null) {
            return furnaceFuels;
        }
        furnaceFuels = ImmutableList.of((Object)new ItemStack(Items.field_151044_h), (Object)new ItemStack(Items.field_151044_h, 1, 1), (Object)new ItemStack(Blocks.field_150364_r), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Blocks.field_150402_ci));
        return furnaceFuels;
    }
}

