/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks.inventory;

import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.steelworks.tileentity.TileHighOven;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHighOven
extends ItemStackHandler {
    public static final int SLOT_FUEL = 3;
    private TileHighOven tile;

    public InventoryHighOven(TileHighOven tile) {
        super(4);
        this.tile = tile;
    }

    public ItemStack getFuel() {
        return this.getStackInSlot(3);
    }

    public ItemStack getAdditive(@Nonnull MixAdditive type) {
        return this.getStackInSlot(type.getSlotIndex());
    }

    public boolean itemValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (slot == 3) {
            return TCompRegistry.isHighOvenFuel(stack);
        }
        MixAdditive type = MixAdditive.fromIndex(slot);
        if (type != null) {
            return TCompRegistry.isValidMixAdditive(stack, type);
        }
        return false;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (!this.itemValidForSlot(slot, stack)) {
            return 0;
        }
        return super.getStackLimit(slot, stack);
    }

    protected void onContentsChanged(int slot) {
        this.tile.markDirtyFast();
    }
}

