/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.ICustomRenderedBlock;
import com.infinityraider.infinitylib.block.ICustomRenderedBlockWithTile;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.BlockRenderer;
import com.infinityraider.infinitylib.render.block.BlockWithTileRenderer;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import com.infinityraider.infinitylib.render.tile.TesrWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockRendererRegistry
implements ICustomModelLoader {
    private static final BlockRendererRegistry INSTANCE = new BlockRendererRegistry();
    private final Map<ResourceLocation, IModel> renderers = new HashMap<ResourceLocation, IModel>();
    private final List<ICustomRenderedBlock> blocks = new ArrayList<ICustomRenderedBlock>();

    public static BlockRendererRegistry getInstance() {
        return INSTANCE;
    }

    private BlockRendererRegistry() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
    }

    public boolean accepts(ResourceLocation loc) {
        return this.renderers.containsKey(loc);
    }

    public IModel loadModel(ResourceLocation loc) throws Exception {
        return this.renderers.get(loc);
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public List<ICustomRenderedBlock> getRegisteredBlocks() {
        return ImmutableList.copyOf(this.blocks);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerCustomBlockRenderer(final ICustomRenderedBlock customRenderedBlock) {
        if (customRenderedBlock == null || !(customRenderedBlock instanceof BlockBase)) {
            return;
        }
        StateMapperBase stateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return customRenderedBlock.getBlockModelResourceLocation();
            }
        };
        ModelLoader.setCustomStateMapper((Block)((BlockBase)((Object)customRenderedBlock)), (IStateMapper)stateMapper);
        if (customRenderedBlock instanceof ICustomRenderedBlockWithTile) {
            this.registerTileRenderer((ICustomRenderedBlockWithTile)customRenderedBlock);
        } else {
            this.registerBlockRenderer(customRenderedBlock);
        }
    }

    private void registerBlockRenderer(ICustomRenderedBlock customRenderedBlock) {
        IBlockRenderingHandler renderer = customRenderedBlock.getRenderer();
        if (renderer != null) {
            BlockRenderer instance = new BlockRenderer(renderer);
            ModelResourceLocation blockModel = customRenderedBlock.getBlockModelResourceLocation();
            this.renderers.put((ResourceLocation)blockModel, instance);
            this.registerInventoryRendering(renderer, blockModel, instance);
            this.blocks.add(customRenderedBlock);
        }
    }

    private void registerTileRenderer(ICustomRenderedBlockWithTile<? extends TileEntityBase> customRenderedBlock) {
        IBlockRenderingHandler renderer = customRenderedBlock.getRenderer();
        if (renderer != null) {
            BlockWithTileRenderer instance = new BlockWithTileRenderer(renderer);
            ModelResourceLocation blockModel = customRenderedBlock.getBlockModelResourceLocation();
            if (renderer.hasStaticRendering()) {
                this.renderers.put((ResourceLocation)blockModel, instance);
            }
            Object tile = renderer.getTileEntity();
            if (renderer.hasDynamicRendering() && tile != null) {
                ClientRegistry.bindTileEntitySpecialRenderer(tile.getClass(), new TesrWrapper(instance));
            }
            this.registerInventoryRendering(renderer, blockModel, instance);
            this.blocks.add(customRenderedBlock);
        }
    }

    private void registerInventoryRendering(@Nonnull IBlockRenderingHandler renderer, @Nonnull ModelResourceLocation loc, @Nonnull IModel model) {
        Preconditions.checkNotNull((Object)renderer);
        Preconditions.checkNotNull((Object)loc);
        Preconditions.checkNotNull((Object)model);
        if (renderer.doInventoryRendering()) {
            ModelResourceLocation itemModel = new ModelResourceLocation(loc.func_110624_b() + ":" + loc.func_110623_a(), "inventory");
            this.renderers.put((ResourceLocation)itemModel, model);
            Item item = Item.func_150898_a(renderer.getBlock());
            if (item != null) {
                ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a(renderer.getBlock()), stack -> itemModel);
            }
        }
    }
}

