/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.DefaultTransforms;
import com.infinityraider.infinitylib.render.item.BakedInfItemSubModel;
import com.infinityraider.infinitylib.render.item.IItemOverriden;
import com.infinityraider.infinitylib.render.item.IItemRenderingHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedInfItemModel
implements IBakedModel,
IItemOverriden {
    @Nonnull
    protected final VertexFormat format;
    @Nonnull
    protected final IItemRenderingHandler renderer;
    @Nonnull
    protected final Function<ResourceLocation, TextureAtlasSprite> textureFunction;
    @Nonnull
    protected final DefaultTransforms.Transformer transformer;
    @Nonnull
    private final ItemOverrideList overrides;
    @Nonnull
    private final Map<Object, BakedInfItemSubModel> cache;

    public BakedInfItemModel(@Nonnull VertexFormat format, @Nonnull IItemRenderingHandler renderer, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textures) {
        this.format = (VertexFormat)Preconditions.checkNotNull((Object)format);
        this.renderer = (IItemRenderingHandler)Preconditions.checkNotNull((Object)renderer);
        this.textureFunction = (Function)Preconditions.checkNotNull(textures);
        this.transformer = (DefaultTransforms.Transformer)Preconditions.checkNotNull((Object)renderer.getPerspectiveTransformer());
        this.overrides = new IItemOverriden.Wrapper(this);
        this.cache = new HashMap<Object, BakedInfItemSubModel>();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transform) {
        return Pair.of((Object)this, this.transformer.apply(transform));
    }

    @Override
    public final BakedInfItemSubModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        return this.cache.computeIfAbsent(this.renderer.getItemQuadsCacheKey(world, stack, entity), k -> new BakedInfItemSubModel(this, stack, world, entity));
    }

    public final ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

