/*
 * Decompiled with CFR 0.152.
 */
package com.royalreject.auxiliumequivalence.gameObjs.blocks;

import com.royalreject.auxiliumequivalence.PEPCore;
import com.royalreject.auxiliumequivalence.gameObjs.ObjectHandler;
import com.royalreject.auxiliumequivalence.gameObjs.blocks.BlockDirection;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.CollectorMK1Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.CollectorMK4Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.CollectorMK5Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.CollectorMK6Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.CollectorMK7Tile;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Collector
extends BlockDirection {
    private final int tier;

    public Collector(int tier) {
        super(Material.field_151592_s);
        this.func_149663_c("ae_collector_MK" + tier);
        this.func_149715_a(1.0f);
        this.func_149711_c(0.3f);
        this.tier = tier;
        this.func_149647_a(ObjectHandler.cTab);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K) {
            switch (this.tier) {
                case 4: {
                    player.openGui((Object)PEPCore.instance, 0, world, x, y, z);
                    break;
                }
                case 5: {
                    player.openGui((Object)PEPCore.instance, 1, world, x, y, z);
                    break;
                }
                case 6: {
                    player.openGui((Object)PEPCore.instance, 2, world, x, y, z);
                    break;
                }
                case 7: {
                    player.openGui((Object)PEPCore.instance, 3, world, x, y, z);
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch (this.tier) {
            case 7: {
                return new CollectorMK7Tile();
            }
            case 6: {
                return new CollectorMK6Tile();
            }
            case 5: {
                return new CollectorMK5Tile();
            }
            case 4: {
                return new CollectorMK4Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        CollectorMK1Tile tile = (CollectorMK1Tile)world.func_175625_s(pos);
        ItemStack charging = ((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)).getStackInSlot(0);
        if (!charging.func_190926_b()) {
            if (charging.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)charging.func_77973_b();
                double max = itemEmc.getMaximumEmc(charging);
                double current = itemEmc.getStoredEmc(charging);
                return MathUtils.scaleToRedstone((double)current, (double)max);
            }
            double needed = tile.getEmcToNextGoal();
            double current = tile.getStoredEmc();
            return MathUtils.scaleToRedstone((double)current, (double)needed);
        }
        return MathUtils.scaleToRedstone((double)tile.getStoredEmc(), (double)tile.getMaximumEmc());
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity ent = world.func_175625_s(pos);
        if (ent != null) {
            IItemHandler handler = (IItemHandler)ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (i == 2 || handler.getStackInSlot(i).func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
            }
        }
        super.func_180663_b(world, pos, state);
    }
}

