/*
 * Decompiled with CFR 0.152.
 */
package com.royalreject.auxiliumequivalence.gameObjs.blocks;

import com.royalreject.auxiliumequivalence.PEPCore;
import com.royalreject.auxiliumequivalence.gameObjs.blocks.BlockDirection;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.RelayMK4Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.RelayMK5Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.RelayMK6Tile;
import com.royalreject.auxiliumequivalence.gameObjs.tiles.RelayMK7Tile;
import javax.annotation.Nonnull;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Relay
extends BlockDirection {
    private final int tier;

    public Relay(int tier) {
        super(Material.field_151576_e);
        this.func_149663_c("ae_relay_MK" + tier);
        this.func_149715_a(1.0f);
        this.func_149711_c(10.0f);
        this.tier = tier;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K) {
            switch (this.tier) {
                case 4: {
                    player.openGui((Object)PEPCore.instance, 5, world, x, y, z);
                    break;
                }
                case 5: {
                    player.openGui((Object)PEPCore.instance, 6, world, x, y, z);
                    break;
                }
                case 6: {
                    player.openGui((Object)PEPCore.instance, 7, world, x, y, z);
                    break;
                }
                case 7: {
                    player.openGui((Object)PEPCore.instance, 8, world, x, y, z);
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch (this.tier) {
            case 7: {
                return new RelayMK7Tile();
            }
            case 6: {
                return new RelayMK6Tile();
            }
            case 5: {
                return new RelayMK5Tile();
            }
            case 4: {
                return new RelayMK4Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            WorldHelper.dropInventory((IItemHandler)((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)), (World)world, (BlockPos)pos);
        }
        super.func_180663_b(world, pos, state);
    }
}

