/*
 * Decompiled with CFR 0.152.
 */
package com.royalreject.auxiliumequivalence.gameObjs.items;

import com.royalreject.auxiliumequivalence.gameObjs.ObjectHandler;
import javax.annotation.Nonnull;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemPEP
extends Item {
    public static final String TAG_ACTIVE = "Active";
    public static final String TAG_MODE = "Mode";
    protected static final ResourceLocation ACTIVE_NAME = new ResourceLocation("auxiliumequivalence", "active");
    protected static final IItemPropertyGetter ACTIVE_GETTER = (stack, world, entity) -> stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_ACTIVE) ? 1.0f : 0.0f;

    public ItemPEP() {
        this.func_77637_a(ObjectHandler.cTab);
    }

    @Nonnull
    public Item func_77655_b(@Nonnull String message) {
        return super.func_77655_b(message);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        boolean diffActive = oldStack.func_77942_o() && newStack.func_77942_o() && oldStack.func_77978_p().func_74764_b(TAG_ACTIVE) && newStack.func_77978_p().func_74764_b(TAG_ACTIVE) && !oldStack.func_77978_p().func_74781_a(TAG_ACTIVE).equals((Object)newStack.func_77978_p().func_74781_a(TAG_ACTIVE));
        boolean diffMode = oldStack.func_77942_o() && newStack.func_77942_o() && oldStack.func_77978_p().func_74764_b(TAG_MODE) && newStack.func_77978_p().func_74764_b(TAG_MODE) && !oldStack.func_77978_p().func_74781_a(TAG_MODE).equals((Object)newStack.func_77978_p().func_74781_a(TAG_MODE));
        return diffActive || diffMode;
    }

    public static double getEmc(ItemStack stack) {
        return ItemHelper.getOrCreateCompound((ItemStack)stack).func_74769_h("StoredEMC");
    }

    public static void setEmc(ItemStack stack, double amount) {
        ItemHelper.getOrCreateCompound((ItemStack)stack).func_74780_a("StoredEMC", amount);
    }

    public static void addEmcToStack(ItemStack stack, double amount) {
        ItemPEP.setEmc(stack, ItemPEP.getEmc(stack) + amount);
    }

    public static void removeEmc(ItemStack stack, double amount) {
        double result = ItemPEP.getEmc(stack) - amount;
        if (result < 0.0) {
            result = 0.0;
        }
        ItemPEP.setEmc(stack, result);
    }

    public static boolean consumeFuel(EntityPlayer player, ItemStack stack, double amount, boolean shouldRemove) {
        if (amount <= 0.0) {
            return true;
        }
        double current = ItemPEP.getEmc(stack);
        if (current < amount) {
            double consume = EMCHelper.consumePlayerFuel((EntityPlayer)player, (double)(amount - current));
            if (consume == -1.0) {
                return false;
            }
            ItemPEP.addEmcToStack(stack, consume);
        }
        if (shouldRemove) {
            ItemPEP.removeEmc(stack, amount);
        }
        return true;
    }
}

