/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.blocks;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.RedstoneOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.item.VariantTab;
import com.personthecat.orestonevariants.properties.BlockPropertiesHelper;
import com.personthecat.orestonevariants.properties.DropProperties;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockOre;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseOreVariant
extends BlockOre {
    public final OreProperties properties;
    public final IBlockState bgBlock;
    private final Block imitationHandler;
    private final boolean hasGravity;
    private final List<DropProperties> currentDrops = CommonMethods.list(new DropProperties[0]);
    private boolean dropsPrepped = false;
    public final Lazy<Item> normalItem = new Lazy<Supplier<Item>>(this::initNormalItem);
    private static final BlockRenderLayer LAYER = Cfg.BlocksCat.translucentTextures ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT_MIPPED;
    public static final PropertyBool DENSE = PropertyBool.func_177716_a((String)"dense");

    protected BaseOreVariant(OreProperties properties, IBlockState bgBlock) {
        super(properties.block.getMapColor());
        BaseOreVariant.createProperties(properties.block, bgBlock).cloneInto((Block)this);
        this.properties = properties;
        this.bgBlock = bgBlock;
        this.imitationHandler = this.initImitationBlock();
        this.hasGravity = this.initGravity();
        this.func_149675_a(this.field_149789_z || this.hasGravity);
        this.func_180632_j(this.createDefaultState());
        this.setRegistryName(this.createName());
        CommonMethods.info("Setting registry name to {}", this.getRegistryName());
        this.func_149647_a(VariantTab.TAB);
    }

    public static BaseOreVariant of(OreProperties properties, IBlockState bgBlock) {
        return properties.name.equals("redstone_ore") ? new RedstoneOreVariant(properties, bgBlock) : new BaseOreVariant(properties, bgBlock);
    }

    private static BlockPropertiesHelper createProperties(BlockPropertiesHelper ore, IBlockState bgBlock) {
        return Cfg.BlocksCat.bgImitation ? BlockPropertiesHelper.merge(ore.properties, bgBlock) : ore;
    }

    protected IBlockState createDefaultState() {
        return this.func_176223_P().func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(false));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DENSE});
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.func_176194_O().func_177619_a().size(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DENSE) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState defaultState = this.func_176223_P();
        return meta == 1 ? defaultState.func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(true)) : defaultState;
    }

    private ResourceLocation createName() {
        String bgFormat = CommonMethods.formatState(this.bgBlock);
        String fgFormat = this.properties.name;
        StringBuilder sb = new StringBuilder(fgFormat);
        if (bgFormat.length() > 0) {
            sb.append('_');
            sb.append(bgFormat);
        }
        return CommonMethods.osvLocation(sb.toString());
    }

    private boolean initGravity() {
        return Cfg.BlocksCat.bgImitation && this.bgBlock.func_177230_c() instanceof BlockFalling;
    }

    private Block initImitationBlock() {
        return Cfg.BlocksCat.bgImitation ? this.bgBlock.func_177230_c() : this.properties.ore.get().func_177230_c();
    }

    private Item initNormalItem() {
        return CommonMethods.find(Main.ITEMS, i -> i.getRegistryName().equals((Object)this.getRegistryName())).orElseThrow(() -> CommonMethods.runExF("Item for {} was not registered correctly.", new Object[]{this}));
    }

    public ItemStack getStack() {
        return new ItemStack((Block)this);
    }

    public ItemStack getStack(IBlockState state) {
        return new ItemStack(this.normalItem.get(), 1, this.func_176201_c(state));
    }

    public ItemStack getBackgroundStack() {
        return CommonMethods.toStack(this.properties.ore.get());
    }

    public Block getBlock() {
        return Cfg.BlocksCat.bgImitation ? this.bgBlock.func_177230_c() : this;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.imitationHandler.isLadder(this.imitate(state), world, pos, entity);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return this.imitationHandler.isBurning(world, pos);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType placement) {
        return this.imitationHandler.canCreatureSpawn(this.imitate(state), world, pos, placement);
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        this.imitationHandler.beginLeavesDecay(this.imitate(state), world, pos);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.imitationHandler.canConnectRedstone(this.imitate(state), world, pos, side);
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return this.imitationHandler.isFoliage(world, pos);
    }

    public boolean addLandingEffects(IBlockState state1, WorldServer server, BlockPos pos, IBlockState state2, EntityLivingBase entity, int particles) {
        return this.imitationHandler.addLandingEffects(this.imitate(state1), server, pos, this.imitate(state2), entity, particles);
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return this.imitationHandler.addRunningEffects(this.imitate(state), world, pos, entity);
    }

    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return this.imitationHandler.addHitEffects(this.imitate(state), world, target, manager);
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return this.imitationHandler.addDestroyEffects(world, pos, manager);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing, IPlantable plant) {
        return this.imitationHandler.canSustainPlant(this.imitate(state), world, pos, facing, plant);
    }

    public boolean isStickyBlock(IBlockState state) {
        return this.getBlock() == Blocks.field_180399_cE;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.imitationHandler.getFlammability(world, pos, side);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.imitationHandler.isFlammable(world, pos, side);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.imitationHandler.getFireSpreadSpeed(world, pos, side);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.imitationHandler.canEntityDestroy(state, world, pos, entity);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        if (this.bgBlock.func_177230_c().equals(Blocks.field_150343_Z) && Cfg.BlocksCat.bgImitation) {
            return EnumPushReaction.BLOCK;
        }
        return this.imitationHandler.func_149656_h(this.imitate(state));
    }

    private IBlockState imitate(IBlockState state) {
        return this.imitationHandler == this.bgBlock.func_177230_c() ? this.bgBlock : state;
    }

    public String func_149739_a() {
        String key = super.func_149739_a();
        return key.endsWith(".") ? this.properties.ore.get().func_177230_c().func_149739_a() : key;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return CommonMethods.toStack(world.func_180495_p(pos));
    }

    public Item asItem(IBlockState state) {
        return this.normalItem.get();
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.asItem(state));
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == LAYER;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        return this.bgBlock.func_193401_d(worldIn, pos, facing);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.bgBlock == null || this.bgBlock.func_185914_p();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        IBlockState ore = this.properties.ore.get();
        ore.func_177230_c().func_180655_c(ore, world, pos, rand);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!this.dropsPrepped) {
            this.checkPrepareDrops(world);
        }
        if (this.properties.drops.isPresent()) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            for (DropProperties drop : this.currentDrops) {
                ItemStack stack = drop.drop.get().func_77946_l();
                int multiple = this.getDropMultiple(rand, state, stack, fortune);
                stack.func_190920_e(drop.count.rand(rand) * multiple);
                drops.add((Object)stack);
            }
        } else {
            IBlockState ore = this.properties.ore.get();
            ore.func_177230_c().getDrops(drops, world, pos, ore, fortune);
        }
        this.replaceSelfDrops(drops, state);
        this.dropsPrepped = false;
    }

    private int getDropMultiple(Random rand, IBlockState state, ItemStack stack, int fortune) {
        boolean isSelfDrop = stack.func_77969_a(this.getStack(state));
        boolean isOreDrop = stack.func_77969_a(CommonMethods.toStack(this.properties.ore.get()));
        boolean isDense = (Boolean)state.func_177229_b((IProperty)DENSE);
        int i = 1;
        if (!isSelfDrop && !isOreDrop || isDense) {
            i = CommonMethods.getMax(1, rand.nextInt(fortune + 2) - 1);
        }
        if (isDense) {
            i *= BaseOreVariant.getDenseMultiple(rand);
        }
        return i;
    }

    private void replaceSelfDrops(NonNullList<ItemStack> drops, IBlockState state) {
        ArrayList<ItemStack> clone = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            boolean isOreDrop = stack.func_77969_a(CommonMethods.toStack(this.properties.ore.get()));
            if (Cfg.BlocksCat.variantsDrop && isOreDrop) {
                ItemStack notDense = CommonMethods.toStack(state.func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(false)));
                notDense.func_190920_e(stack.func_190916_E());
                clone.add(notDense);
                continue;
            }
            clone.add(stack);
        }
        drops.clear();
        drops.addAll(clone);
    }

    public int getExpDrop(IBlockState state, IBlockAccess reader, BlockPos pos, int fortune) {
        this.checkPrepareDrops(reader);
        if (this.properties.drops.isPresent()) {
            int xp = 0;
            for (DropProperties drop : this.currentDrops) {
                Random rand = reader instanceof World ? ((World)reader).field_73012_v : new Random();
                xp += drop.xp.rand(rand);
            }
            return xp;
        }
        IBlockState ore = this.properties.ore.get();
        return ore.func_177230_c().getExpDrop(ore, reader, pos, fortune);
    }

    private void checkPrepareDrops(IBlockAccess reader) {
        if (reader instanceof World) {
            World world = (World)reader;
            if (!world.field_72995_K) {
                this.prepareDrops(world.field_73012_v);
            }
        } else {
            this.prepareDrops(new Random());
        }
    }

    private synchronized void prepareDrops(Random rand) {
        this.currentDrops.clear();
        this.properties.drops.ifPresent(drops -> drops.forEach(drop -> {
            if (drop.chance == 1.0 || (double)rand.nextFloat() <= drop.chance) {
                this.currentDrops.add((DropProperties)drop);
            }
        }));
        this.dropsPrepped = true;
    }

    private static int getDenseMultiple(Random rand) {
        int i = Cfg.DenseCat.dropMultiplier;
        if (Cfg.DenseCat.randomDropCount) {
            i = CommonMethods.numBetween(rand, 1, i);
        }
        if (i < Cfg.DenseCat.dropMultiplierMin) {
            i = Cfg.DenseCat.dropMultiplierMin;
        }
        return i;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        if (Cfg.BlocksCat.variantsSilktouch) {
            return CommonMethods.toStack(state);
        }
        if (((Boolean)state.func_177229_b((IProperty)DENSE)).booleanValue()) {
            ItemStack stack = Cfg.BlocksCat.variantsDrop ? CommonMethods.toStack(state.func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(false))) : CommonMethods.toStack(this.properties.ore.get());
            stack.func_190920_e(this.getDropMultiple(new Random(), state, stack, 0));
            return stack;
        }
        return CommonMethods.toStack(this.properties.ore.get());
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.hasGravity) {
            world.func_175684_a(pos, (Block)this, 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.hasGravity) {
            world.func_175684_a(pos, (Block)this, 2);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.handleGravity(state, world, pos);
    }

    private void handleGravity(IBlockState state, World world, BlockPos pos) {
        if (!world.field_72995_K && this.hasGravity) {
            this.checkFallable(state, world, pos);
        }
    }

    private void checkFallable(IBlockState state, World world, BlockPos pos) {
        if (pos.func_177956_o() > 0 && BaseOreVariant.canFallThrough(world.func_180495_p(pos.func_177977_b()))) {
            world.func_72838_d((Entity)new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state));
        }
    }

    private static boolean canFallThrough(IBlockState state) {
        Material mat = state.func_185904_a();
        return mat == Material.field_151579_a || mat.func_76224_d() || mat.func_76222_j();
    }

    public void registerModels() {
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ResourceLocation name = this.getRegistryName();
            StringBuilder fullName = new StringBuilder(name.func_110623_a());
            boolean dense = (Boolean)state.func_177229_b((IProperty)DENSE);
            int meta = this.func_176201_c(state);
            Item item = this.asItem(state);
            if (dense) {
                fullName.insert(0, "dense_");
            }
            ModelResourceLocation inv = CommonMethods.mrl(CommonMethods.osvLocation(fullName.toString()), "inventory");
            Main.proxy.registerVariantRenderer(item, meta, inv);
        }
    }
}

