/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.blocks;

import com.personthecat.orestonevariants.blocks.BlockGroup;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.PropertyGroup;
import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockEntry {
    public final PropertyGroup properties;
    public final BlockGroup blocks;

    private BlockEntry(String properties, String blocks) {
        this.properties = PropertyGroup.findOrCreate(properties);
        this.blocks = BlockGroup.findOrCreate(blocks);
    }

    private static Stream<BlockEntry> create(String entry) {
        String[] split = BlockEntry.split(entry);
        if (BlockEntry.loadTest(split[0]) && BlockEntry.loadTest(split[1])) {
            CommonMethods.info("{}, {} is valid. Loading...", split[0], split[1]);
            return Stream.of(new BlockEntry(split[0], split[1]));
        }
        return Stream.empty();
    }

    public static Set<BlockEntry> setupEntries() {
        Set<BlockEntry> entries = Stream.of(Cfg.BlockRegistryCat.values).flatMap(BlockEntry::create).filter(BlockEntry::modsSupported).collect(Collectors.toSet());
        if (Cfg.BlockRegistryCat.testForDuplicates) {
            BlockEntry.testForDuplicates(entries);
        }
        return entries;
    }

    private static void testForDuplicates(Set<BlockEntry> entries) {
        BlockEntry.forAllEntries(entries, (TriConsumer<Integer, IBlockState, OreProperties>)((TriConsumer)(index1, block1, props1) -> BlockEntry.forAllEntries(entries, (TriConsumer<Integer, IBlockState, OreProperties>)((TriConsumer)(index2, block2, props2) -> {
            if (!index1.equals(index2) && block1.equals(block2) && props1.equals(props2)) {
                throw CommonMethods.runExF("Registry error: multiple entries generated with {} in {}. Check your block list.", props1.oreLookup, block1);
            }
        }))));
    }

    private static void forAllEntries(Set<BlockEntry> entries, TriConsumer<Integer, IBlockState, OreProperties> fun) {
        int i = 0;
        for (BlockEntry entry : entries) {
            for (IBlockState block : entry.blocks.blocks.get()) {
                for (OreProperties props : entry.properties.properties) {
                    fun.accept((Object)i, (Object)block, (Object)props);
                }
            }
            ++i;
        }
    }

    private static boolean loadTest(String mod) {
        return (mod = mod.toLowerCase()).equals("default") || mod.equals("all") || !Cfg.modFamiliar(mod) || BlockEntry.modEnabled(mod);
    }

    private boolean modsSupported() {
        return this.blocks.mod.map(BlockEntry::modEnabled).orElse(true) != false && this.properties.mod.map(BlockEntry::modEnabled).orElse(true) != false;
    }

    private static boolean modEnabled(String mod) {
        return Cfg.modEnabled(mod) && CommonMethods.isModLoaded(mod);
    }

    public static String[] split(String entry) {
        Object[] split = entry.split("[, ]");
        ArrayUtils.removeAllOccurences((Object[])split, (Object)"");
        assert (split.length == 2);
        split[0] = ((String)split[0]).trim();
        split[1] = ((String)split[1]).trim();
        return split;
    }

    public String toString() {
        return CommonMethods.f("BlockGroup{{} ores -> {} blocks}", this.properties.name, this.blocks.name);
    }
}

