/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.blocks;

import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneOreVariant
extends BaseOreVariant {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private static final int DENSE_BIT = 2;
    private static final int LIT_BIT = 1;

    protected RedstoneOreVariant(OreProperties properties, IBlockState bgBlock) {
        super(properties, bgBlock);
        this.func_149675_a(true);
    }

    @Override
    protected IBlockState createDefaultState() {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DENSE, LIT});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)DENSE)).booleanValue()) {
            meta |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 1;
        }
        return meta;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if ((meta & 2) == 2) {
            state = state.func_177226_a((IProperty)DENSE, (Comparable)Boolean.valueOf(true));
        }
        if ((meta & 1) == 1) {
            state = state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            RedstoneOreVariant.spawnRedstoneParticles(world, pos);
        }
    }

    public boolean func_149653_t() {
        return true;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return CommonMethods.toStack(state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer player) {
        this.activate(worldIn.func_180495_p(pos), worldIn, pos);
        super.func_180649_a(worldIn, pos, player);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.activate(worldIn.func_180495_p(pos), worldIn, pos);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.activate(worldIn.func_180495_p(pos), worldIn, pos);
        return super.func_180639_a(worldIn, pos, state, player, handIn, facing, hitX, hitY, hitZ);
    }

    private void activate(IBlockState state, World world, BlockPos pos) {
        if (world.field_72995_K) {
            RedstoneOreVariant.spawnRedstoneParticles(world, pos);
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static void spawnRedstoneParticles(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        double d1 = (float)pos.func_177958_n() + random.nextFloat();
        double d2 = (float)pos.func_177956_o() + random.nextFloat();
        double d3 = (float)pos.func_177952_p() + random.nextFloat();
        for (int i = 0; i < 6; ++i) {
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + 0.0625 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + 0.0625 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - 0.0625;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + 0.0625 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - 0.0625;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

