/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.commands;

import com.personthecat.orestonevariants.config.ModConfigSupport;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.PropertyGenerator;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.ArrayUtils;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class CommandOSV
extends CommandBase {
    private static final Style USAGE_HEADER_STYLE = new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
    private static final Style USAGE_STYLE = new Style().func_150238_a(TextFormatting.GRAY);
    private static final String[][] USAGE_TEXT = new String[][]{{"generate <ore_name> [name]", "Generates an ore preset from the specified", "registry name. World gen is not included."}, {"editConfig <mod_name|all>", "Attempts to disable all ore generation for", "the specified mod via its config file."}, {"setStoneLayer <preset> <min> <max> <density>", "Attempts to generate world gen variables", "based on a range of y values and a 0-1 density."}, {"update <dir> <cfg> <key_path> <value>", "Manually update a preset value."}};
    private static final int USAGE_LENGTH = 5;
    private static final String USAGE_HEADER = " --- OSV Command Usage ({} / {}) ---";
    private static final ITextComponent[] USAGE_MSG = CommandOSV.createHelpMessage();
    private static Pattern ARRAY_PATTERN = Pattern.compile("(.*)\\[(.*)\\]");

    public String func_71517_b() {
        return "osv";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/osv <subcommand>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 0) {
            CommandOSV.displayHelp(sender, 1);
            return;
        }
        int splitIndex = ArrayUtils.lastIndexOf((Object[])args, (Object)"&&");
        if (splitIndex > 0 && args.length > splitIndex) {
            String[] runFirst = (String[])ArrayUtils.subarray((Object[])args, (int)0, (int)splitIndex);
            args = (String[])ArrayUtils.subarray((Object[])args, (int)(splitIndex + 1), (int)args.length);
            this.func_184881_a(server, sender, runFirst);
        }
        try {
            String[] slice = (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length);
            CommandOSV.handle(server, sender, args[0], slice);
        }
        catch (RuntimeException e) {
            CommandOSV.sendMessage(sender, e.getMessage());
        }
    }

    private static void handle(MinecraftServer server, ICommandSender sender, String command, String[] args) {
        switch (command.toLowerCase()) {
            case "generate": {
                CommandOSV.generate(server, sender, args);
                break;
            }
            case "configedit": 
            case "editconfig": {
                CommandOSV.editConfig(sender, args);
                break;
            }
            case "setstonelayer": {
                CommandOSV.setStoneLayer(sender, args);
                break;
            }
            case "update": {
                CommandOSV.update(sender, args);
                break;
            }
            default: {
                CommandOSV.displayHelp(sender, 1);
            }
        }
    }

    private static void generate(MinecraftServer server, ICommandSender sender, String[] args) {
        CommandOSV.requireArgs(args, 1);
        IBlockState ore = CommonMethods.getBlockState(args[0]).orElseThrow(() -> CommonMethods.runExF("There is no block named {}.", args[0]));
        WorldServer world = server.func_71218_a(0);
        Optional<String> name = CommonMethods.safeGet(args, 1);
        JsonObject json = PropertyGenerator.getBlockInfo(ore, (World)world, name);
        String fileName = HjsonTools.getString(json, "name").orElseThrow(() -> CommonMethods.runEx("Unreachable."));
        File file = new File(OreProperties.DIR, fileName + ".hjson");
        HjsonTools.writeJson(json, file).expect("Error writing new hjson file.");
        CommandOSV.sendMessage(sender, "Finished writing new preset.");
    }

    private static void editConfig(ICommandSender sender, String[] args) {
        CommandOSV.requireArgs(args, 1);
        if (ModConfigSupport.updateConfig(args[0])) {
            CommandOSV.sendMessage(sender, "Successfully updated mod config! Restart your game to see changes.");
        } else {
            CommandOSV.sendMessage(sender, "Invalid or unloaded mod.");
        }
    }

    private static void setStoneLayer(ICommandSender sender, String[] args) {
        CommandOSV.requireArgs(args, 4);
        String cfg = args[0];
        int min = Integer.parseInt(args[1]);
        int max = Integer.parseInt(args[2]);
        double density = Double.parseDouble(args[3]);
        int size = (int)((double)(max - min + 25) * density);
        size = CommonMethods.getMin(52, size);
        int count = (int)((1.0 - density) * (double)(max - min) * 15.0 / 5.0) + 15;
        CommandOSV.update(sender, "stone", cfg, "gen[0].height", CommonMethods.f("[{},{}]", min, max));
        CommandOSV.update(sender, "stone", cfg, "gen[0].size", String.valueOf(size));
        CommandOSV.update(sender, "stone", cfg, "gen[0].count", String.valueOf(count));
    }

    private static void update(ICommandSender sender, String ... args) {
        CommandOSV.requireArgs(args, 4);
        File dir = new File(CommonMethods.getConfigDir() + "/osv", args[0]);
        File cfg = new File(dir, args[1] + ".hjson");
        String path = args[2];
        JsonValue value = JsonValue.readHjson(CommandOSV.joinAfter(args, 3));
        String filename = cfg.getName();
        JsonObject preset = HjsonTools.readJson(cfg).orElseThrow(() -> CommonMethods.runExF("Preset not found: ", filename));
        CommandOSV.setValueFromPath(preset, path, value);
        HjsonTools.writeJson(preset, cfg).expectF("Error updating ", filename);
        CommandOSV.sendMessage(sender, "Successfully updated " + filename);
    }

    private static String joinAfter(String[] array, int index) {
        StringBuilder sb = new StringBuilder(array[index]);
        for (int i = index + 1; i < array.length; ++i) {
            sb.append(' ');
            sb.append(array[i]);
        }
        return sb.toString();
    }

    private static void setValueFromPath(JsonObject json, String path, JsonValue value) {
        String[] split = path.split(Pattern.quote("."));
        if (split.length == 0) {
            return;
        }
        JsonObject current = json;
        for (int i = 0; i < split.length - 1; ++i) {
            Matcher matcher = ARRAY_PATTERN.matcher(split[i]);
            if (matcher.matches()) {
                String key = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                JsonArray array = CommandOSV.getOrNewArray(current, key);
                JsonObject fromIndex = CommandOSV.getOrNewObj(array, index);
                if (!((JsonValue)fromIndex).isObject()) {
                    throw CommonMethods.runEx("Only arrays containing objects can be updated by index.");
                }
                current = ((JsonValue)fromIndex).asObject();
                continue;
            }
            current = CommandOSV.getOrNewObj(current, split[i]);
        }
        current.set(split[split.length - 1], value);
    }

    private static JsonObject getOrNewObj(JsonObject json, String key) {
        if (!json.has(key)) {
            json.set(key, new JsonObject());
        }
        return json.get(key).asObject();
    }

    private static JsonObject getOrNewObj(JsonArray array, int index) {
        if (array.size() <= index) {
            array.set(index, new JsonObject());
        }
        return array.get(index).asObject();
    }

    private static JsonArray getOrNewArray(JsonObject json, String key) {
        if (!json.has(key)) {
            json.set(key, new JsonArray());
        }
        return json.get(key).asArray();
    }

    private static void displayHelp(ICommandSender sender, int page) {
        if (page > USAGE_MSG.length || page <= 0) {
            CommandOSV.sendMessage(sender, "Invalid page #.");
            return;
        }
        sender.func_145747_a(USAGE_MSG[page - 1]);
    }

    private static ITextComponent[] createHelpMessage() {
        ArrayList<TextComponentString> msgs = new ArrayList<TextComponentString>();
        int numLines = CommandOSV.getNumElements(USAGE_TEXT) - USAGE_TEXT.length;
        int numPages = (int)Math.ceil((double)numLines / 5.0) - 1;
        for (int i = 0; i < USAGE_TEXT.length; i += 5) {
            TextComponentString header = CommandOSV.getUsageHeader(i / 5 + 1, numPages);
            for (int j = i; j < i + 5; ++j) {
                if (j >= USAGE_TEXT.length) continue;
                String[] full = USAGE_TEXT[j];
                header.func_150258_a("\n");
                CommandOSV.appendUsageText((ITextComponent)header, full[0], full[1]);
                for (int k = 2; k < full.length; ++k) {
                    header.func_150258_a(" ");
                    header.func_150257_a(CommandOSV.tcs(full[k]).func_150255_a(USAGE_STYLE));
                }
            }
            msgs.add(header);
        }
        return (ITextComponent[])CommonMethods.toArray(msgs, TextComponentString.class);
    }

    private static int getNumElements(String[][] matrix) {
        int numElements = 0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ++numElements;
            }
        }
        return numElements;
    }

    private static TextComponentString getUsageHeader(int page, int max) {
        String header = CommonMethods.f(USAGE_HEADER, String.valueOf(page), String.valueOf(max));
        TextComponentString full = CommandOSV.tcs("");
        TextComponentString headerTCS = CommandOSV.tcs(header);
        headerTCS.func_150255_a(USAGE_HEADER_STYLE);
        full.func_150257_a((ITextComponent)headerTCS);
        return full;
    }

    private static void appendUsageText(ITextComponent msg, String command, String usage) {
        msg.func_150257_a(CommandOSV.usageText(command, usage));
    }

    private static ITextComponent usageText(String command, String usage) {
        TextComponentString msg = CommandOSV.tcs("");
        msg.func_150257_a((ITextComponent)CommandOSV.tcs(command));
        msg.func_150257_a(CommandOSV.tcs(" :\n " + usage).func_150255_a(USAGE_STYLE));
        return msg;
    }

    private static void sendMessage(ICommandSender user, String msg) {
        user.func_145747_a((ITextComponent)CommandOSV.tcs(msg));
    }

    private static TextComponentString tcs(String s) {
        return new TextComponentString(s);
    }

    private static void requireArgs(String[] args, int num) {
        if (args.length < num) {
            throw CommonMethods.runEx("Insufficient arguments for this command.");
        }
    }
}

