/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.io;

import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.PropertyGroup;
import com.personthecat.orestonevariants.properties.StoneProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.unsafe.Result;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;

public class JarFiles {
    private static final File ORES = OreProperties.DIR;
    private static final File STONE = StoneProperties.DIR;

    public static void copyPresetFiles() {
        JarFiles.copyFilesFrom(ORES, PropertyGroup.DefaultInfo.getAllNames());
        JarFiles.copyFilesFrom(STONE, StoneProperties.getDefaultNames());
    }

    private static void copyFilesFrom(File dir, List<String> names) {
        SafeFileIO.ensureDirExists(dir).expect("Error creating the preset directory.");
        for (String name : names) {
            String from = CommonMethods.f("assets/{}/{}/{}.hjson", "osv", dir.getName(), name);
            String to = CommonMethods.f("{}/{}.hjson", dir.getPath(), name);
            if (SafeFileIO.fileExists(new File(to), "Error validating preset file.")) continue;
            JarFiles.copyFile(from, to);
        }
    }

    private static void copyFile(String from, String to) {
        Result.with(() -> new FileOutputStream(to), fos -> {
            InputStream toCopy = SafeFileIO.getRequiredResource(from);
            SafeFileIO.copyStream(toCopy, fos, 1024).throwIfErr();
        }).expect("Error copying file from the jar.");
    }
}

