/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayBakedModel
implements IBakedModel {
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final IBakedModel background;
    private final IBakedModel overlay;

    public OverlayBakedModel(IBakedModel background, IBakedModel overlay) {
        this.transforms = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)background.func_177552_f());
        this.background = background;
        this.overlay = overlay;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            return this.getAllQuads(state, side, rand);
        }
        if (layer == BlockRenderLayer.SOLID) {
            return this.background.func_188616_a(state, side, rand);
        }
        return this.overlay.func_188616_a(state, side, rand);
    }

    private List<BakedQuad> getAllQuads(IBlockState state, EnumFacing side, long rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)this.background.func_188616_a(state, side, rand));
        builder.addAll((Iterable)this.overlay.func_188616_a(state, side, rand));
        return builder.build();
    }

    public boolean func_177555_b() {
        return this.background.func_177555_b();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.background.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.background.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.background.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.background.func_177554_e();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

