/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.unsafe.ReflectionTools;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

public class BlockPropertiesHelper {
    public final Block properties;
    private static final Field material = BlockPropertiesHelper.reflect("material", "field_149764_J", 18);
    private static final Field mapColor = BlockPropertiesHelper.reflect("blockMapColor", "field_181083_K", 19);
    private static final Field soundType = BlockPropertiesHelper.reflect("blockSoundType", "field_149762_H", 16);
    private static final Field lightValue = BlockPropertiesHelper.reflect("lightValue", "field_149784_t", 9);
    private static final Field resistance = BlockPropertiesHelper.reflect("blockResistance", "field_149781_w", 12);
    private static final Field hardness = BlockPropertiesHelper.reflect("blockHardness", "field_149782_v", 11);
    private static final Field ticksRandomly = BlockPropertiesHelper.reflect("needsRandomTick", "field_149789_z", 14);
    private static final Field slipperiness = BlockPropertiesHelper.reflect("slipperiness", "field_149765_K", 20);
    private static final Field translationKey = BlockPropertiesHelper.reflect("translationKey", "field_111090_h", 23);

    public BlockPropertiesHelper(Material material, MapColor color) {
        this(new Block(material, color));
    }

    public BlockPropertiesHelper(Block properties) {
        this.properties = properties;
    }

    public static BlockPropertiesHelper from(JsonObject json) {
        Material material = HjsonTools.getMaterialOr(json, "material", Material.field_151576_e);
        MapColor color = HjsonTools.getMapColorOr(json, "mapColor", MapColor.field_151665_m);
        return new BlockPropertiesHelper(material, color).setSoundType(HjsonTools.getSoundTypeOr(json, "soundType", SoundType.field_185851_d)).setLightValue(HjsonTools.getIntOr(json, "light", 0)).setResistance(HjsonTools.getFloatOr(json, "resistance", 15.0f)).setHardness(HjsonTools.getFloatOr(json, "hardness", 3.0f)).setTicksRandomly(HjsonTools.getBoolOr(json, "ticksRandomly", false)).setSlipperiness(HjsonTools.getFloatOr(json, "slipperiness", 0.6f)).setHarvestLevel(HjsonTools.getIntOr(json, "level", 1)).setHarvestTool(HjsonTools.getStringOr(json, "tool", "pickaxe")).setTranslationKey(HjsonTools.getStringOr(json, "translationKey", ""));
    }

    public static BlockPropertiesHelper merge(Block ore, IBlockState bg) {
        return BlockPropertiesHelper.merge(ore, bg.func_177230_c());
    }

    public static BlockPropertiesHelper merge(Block oreProps, Block bgProps) {
        BlockPropertiesHelper ore = new BlockPropertiesHelper(oreProps);
        BlockPropertiesHelper bg = new BlockPropertiesHelper(bgProps);
        Material material = bg.getMaterial();
        MapColor color = bg.getMapColor();
        return new BlockPropertiesHelper(material, color).setSoundType(bg.getSoundType()).setLightValue(CommonMethods.getMax(ore.getLightValue(), bg.getLightValue())).setResistance(CommonMethods.getMax(ore.getResistance(), bg.getResistance())).setHardness(BlockPropertiesHelper.mergeHardness(ore.getHardness(), bg.getHardness())).setTicksRandomly(ore.getTicksRandomly() || bg.getTicksRandomly()).setSlipperiness(CommonMethods.avg(ore.getSlipperiness(), bg.getSlipperiness())).setHarvestLevel(CommonMethods.getMax(ore.getHarvestLevel(), bg.getHarvestLevel())).setHarvestTool(bg.getHarvestTool()).setTranslationKey(ore.getTranslationKey());
    }

    public void cloneInto(Block other) {
        new BlockPropertiesHelper(other).setSoundType(this.getSoundType()).setLightValue(this.getLightValue()).setResistance(this.getResistance()).setHardness(this.getHardness()).setTicksRandomly(this.getTicksRandomly()).setSlipperiness(this.getSlipperiness()).setHarvestLevel(this.getHarvestLevel()).setHarvestTool(this.getHarvestTool()).setTranslationKey(this.getTranslationKey());
    }

    public Material getMaterial() {
        return (Material)this.get(material);
    }

    public MapColor getMapColor() {
        return (MapColor)this.get(mapColor);
    }

    public BlockPropertiesHelper setSoundType(SoundType sound) {
        this.set(soundType, sound);
        return this;
    }

    public SoundType getSoundType() {
        return (SoundType)this.get(soundType);
    }

    public BlockPropertiesHelper setLightValue(int value) {
        this.set(lightValue, value);
        return this;
    }

    public int getLightValue() {
        return (Integer)this.get(lightValue);
    }

    public BlockPropertiesHelper setResistance(float r) {
        this.set(resistance, Float.valueOf(r));
        return this;
    }

    public float getResistance() {
        return ((Float)this.get(resistance)).floatValue();
    }

    public BlockPropertiesHelper setHardness(float h) {
        this.set(hardness, Float.valueOf(h));
        return this;
    }

    public float getHardness() {
        return ((Float)this.get(hardness)).floatValue();
    }

    private static float mergeHardness(float ore, float bg) {
        return bg < 0.0f ? -1.0f : CommonMethods.getMax(ore + bg - 1.5f, 0.0f);
    }

    public BlockPropertiesHelper setTicksRandomly(boolean ticks) {
        this.set(ticksRandomly, ticks);
        return this;
    }

    public boolean getTicksRandomly() {
        return (Boolean)this.get(ticksRandomly);
    }

    public BlockPropertiesHelper setSlipperiness(float slip) {
        this.set(slipperiness, Float.valueOf(slip));
        return this;
    }

    public float getSlipperiness() {
        return ((Float)this.get(slipperiness)).floatValue();
    }

    public BlockPropertiesHelper setHarvestLevel(int level) {
        IBlockState defaultState = this.properties.func_176223_P();
        String harvestTool = CommonMethods.nullable(this.properties.getHarvestTool(defaultState)).orElse("pickaxe");
        this.properties.setHarvestLevel(harvestTool, level);
        return this;
    }

    public int getHarvestLevel() {
        return this.properties.getHarvestLevel(this.properties.func_176223_P());
    }

    public BlockPropertiesHelper setHarvestTool(String type) {
        IBlockState defaultState = this.properties.func_176223_P();
        int harvestLevel = this.properties.getHarvestLevel(defaultState);
        this.properties.setHarvestLevel(type, harvestLevel);
        return this;
    }

    public String getHarvestTool() {
        return this.properties.getHarvestTool(this.properties.func_176223_P());
    }

    public BlockPropertiesHelper setTranslationKey(String key) {
        this.set(translationKey, key);
        return this;
    }

    public String getTranslationKey() {
        return (String)this.get(translationKey);
    }

    private static Field reflect(String name, String obfName, int index) {
        return ReflectionTools.getField(Block.class, name, obfName, index);
    }

    private void set(Field f, Object o) {
        try {
            f.set(this.properties, o);
        }
        catch (IllegalAccessException e) {
            throw this.invalidFieldError(f);
        }
    }

    private Object get(Field f) {
        try {
            return f.get(this.properties);
        }
        catch (IllegalAccessException e) {
            throw this.invalidFieldError(f);
        }
    }

    private RuntimeException invalidFieldError(Field f) {
        return CommonMethods.runExF("Build error: field `{}` registered incorrectly.", f.getName());
    }
}

