/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.mojang.authlib.GameProfile;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.properties.BlockPropertiesHelper;
import com.personthecat.orestonevariants.recipes.RecipeHelper;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.ExtendedResourceLocation;
import com.personthecat.orestonevariants.util.ValueLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.hjson.JsonArray;
import org.hjson.JsonObject;

public class PropertyGenerator {
    private static final int DROP_SAMPLES = 300;
    private static final String[] TEXTURE_TEMPLATES = new String[]{"blocks/{}", "blocks/ore/{}", "blocks/ores/{}", "blocks/{}_vanilla", "/ore/{}", "/ores/", "{}"};

    public static JsonObject getBlockInfo(IBlockState ore, World world, Optional<String> blockName) {
        String name = blockName.orElse(CommonMethods.formatState(ore));
        ResourceLocation location = CommonMethods.nullable(ore.func_177230_c().getRegistryName()).orElseThrow(() -> CommonMethods.runEx("Error with input block's registry information."));
        String mod = location.func_110624_b();
        String actualName = location.func_110623_a();
        BlockPos dummy = BlockPos.field_177992_a;
        EntityPlayer entity = PropertyGenerator.getFakePlayer(world);
        JsonObject json = new JsonObject();
        json.setComment("This preset was generated automatically. To enable\ncustom generation settings, you must manually define\n`gen`. See TUTORIAL.hjson.");
        json.set("name", name);
        json.set("mod", mod);
        json.set("block", PropertyGenerator.getBlock(ore, world, dummy, entity));
        json.set("texture", PropertyGenerator.getTexture(mod, actualName));
        json.set("recipe", PropertyGenerator.getRecipe(ore));
        json.set("loot", PropertyGenerator.getDrops(ore, world, dummy, entity));
        return json;
    }

    private static JsonObject getBlock(IBlockState ore, World world, BlockPos pos, EntityPlayer entity) {
        JsonObject json = new JsonObject();
        Block block = ore.func_177230_c();
        ExtendedResourceLocation location = ExtendedResourceLocation.fromState(ore);
        BlockPropertiesHelper helper = new BlockPropertiesHelper(block);
        String material = ValueLookup.serialize(ore.func_185904_a()).orElseThrow(() -> CommonMethods.runEx("Only vanilla material types are supported."));
        String sound = ValueLookup.serialize(block.getSoundType(ore, world, pos, (Entity)entity)).orElseThrow(() -> CommonMethods.runEx("Only vanilla sound types are supported."));
        float slipperiness = PropertyGenerator.formatDecimal(block.getSlipperiness(ore, (IBlockAccess)world, pos, (Entity)entity));
        json.set("location", location.toString());
        json.set("level", block.getHarvestLevel(ore));
        json.set("material", material);
        json.set("soundType", sound);
        json.set("lightLevel", ore.getLightValue((IBlockAccess)world, pos));
        json.set("resistance", helper.getResistance());
        json.set("hardness", ore.func_185887_b(world, pos));
        json.set("ticksRandomly", block.func_149653_t());
        json.set("slipperiness", slipperiness);
        json.set("tool", block.getHarvestTool(ore));
        return json;
    }

    private static JsonObject getTexture(String mod, String name) {
        JsonObject json = new JsonObject();
        PropertyGenerator.getTextureLocation(mod, name).ifPresent(path -> json.set("original", (String)path));
        return json;
    }

    private static Optional<String> getTextureLocation(String mod, String name) {
        for (String template : TEXTURE_TEMPLATES) {
            String path = CommonMethods.f(template, name);
            String expanded = CommonMethods.f("/assets/{}/textures/{}.png", mod, path);
            if (!SafeFileIO.getResource(expanded).isPresent()) continue;
            return CommonMethods.full(CommonMethods.f("{}:{}", mod, path));
        }
        return CommonMethods.empty();
    }

    private static JsonObject getRecipe(IBlockState ore) {
        JsonObject json = new JsonObject();
        ItemStack result = RecipeHelper.resultOf(CommonMethods.toStack(ore)).orElseThrow(() -> CommonMethods.runExF("Unable to find smelting result for {}.", ore));
        ExtendedResourceLocation location = ExtendedResourceLocation.fromStack(result);
        float xp = PropertyGenerator.formatDecimal(RecipeHelper.getExperience(result));
        json.set("result", location.toString());
        json.set("xp", xp);
        json.set("quantity", result.func_190916_E());
        return json;
    }

    private static JsonArray getDrops(IBlockState ore, World world, BlockPos pos, EntityPlayer player) {
        JsonArray array = new JsonArray();
        List<ItemStack> drops = PropertyGenerator.getAllDrops(ore, world, pos, player);
        List<DropData> data = PropertyGenerator.getDropData(drops);
        DropData xpData = PropertyGenerator.getXPData(ore, world, pos, player);
        data.forEach(dat -> {
            ItemStack stack = dat.stack;
            float chance = dat.numStacks / 300.0f;
            JsonObject json = new JsonObject().set("item", ExtendedResourceLocation.fromStack(stack).toString()).set("count", new JsonArray().add((int)dat.min).add((int)dat.max).setCondensed(true)).set("xp", new JsonArray().add(xpData.min * chance).add(xpData.max * chance).setCondensed(true)).set("chance", chance);
            array.add(json);
        });
        return array;
    }

    private static List<ItemStack> getAllDrops(IBlockState ore, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Block block = ore.func_177230_c();
        for (int i = 0; i < 300; ++i) {
            block.func_180649_a(world, pos, player);
            List sample = block.getDrops((IBlockAccess)world, pos, ore, 0);
            drops.addAll(PropertyGenerator.reduce(sample));
        }
        return drops;
    }

    private static List<ItemStack> reduce(List<ItemStack> drops) {
        return PropertyGenerator.getDropData(drops).stream().map(data -> {
            data.stack.func_190920_e((int)data.total);
            return data.stack;
        }).collect(Collectors.toList());
    }

    private static List<DropData> getDropData(List<ItemStack> drops) {
        ArrayList<DropData> data = new ArrayList<DropData>();
        for (ItemStack drop : drops) {
            int index = Collections.binarySearch(data, drop);
            if (index < 0) {
                data.add(-index - 1, new DropData(drop));
                continue;
            }
            ((DropData)data.get(index)).update(drop.func_190916_E());
        }
        return data;
    }

    private static DropData getXPData(IBlockState ore, World world, BlockPos pos, EntityPlayer player) {
        Block block = ore.func_177230_c();
        DropData xpData = new DropData(block.getExpDrop(ore, (IBlockAccess)world, pos, 0));
        for (int i = 1; i < 300; ++i) {
            block.func_180649_a(world, pos, player);
            xpData.update(block.getExpDrop(ore, (IBlockAccess)world, pos, 0));
        }
        return xpData;
    }

    private static EntityPlayer getFakePlayer(World world) {
        GameProfile profile = new GameProfile(new UUID(0L, 0L), "");
        return new FakePlayer(world.func_73046_m().func_71218_a(0), profile);
    }

    private static float formatDecimal(float f) {
        return (float)Math.round(f * 1000.0f) / 1000.0f;
    }

    private static class DropData
    implements Comparable<ItemStack> {
        final ItemStack stack;
        float min;
        float max;
        float numStacks = 1.0f;
        float total;

        DropData(ItemStack stack) {
            this.stack = stack;
            this.max = this.total = (float)stack.func_190916_E();
            this.min = this.total;
            stack.func_190920_e(1);
        }

        DropData(float count) {
            this.stack = ItemStack.field_190927_a;
            this.min = this.max = count;
            this.total = 1.0f;
        }

        void update(float count) {
            this.min = CommonMethods.getMin(this.min, count);
            this.max = CommonMethods.getMax(this.max, count);
            this.total += count;
            this.numStacks += 1.0f;
        }

        @Override
        public int compareTo(ItemStack other) {
            return Integer.compare(DropData.getHash(this.stack), DropData.getHash(other));
        }

        private static int getHash(ItemStack stack) {
            return Item.func_150891_b((Item)stack.func_77973_b()) << 4 | stack.func_77960_j();
        }
    }
}

