/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.textures;

import com.google.common.collect.Lists;
import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.io.FileSpec;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.io.ZipTools;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.TextureProperties;
import com.personthecat.orestonevariants.textures.ImageTools;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.PathSet;
import com.personthecat.orestonevariants.util.PathTools;
import com.personthecat.orestonevariants.util.unsafe.ReflectionTools;
import com.personthecat.orestonevariants.util.unsafe.Result;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;

public class SpriteHandler {
    public static final Lazy<Collection<IResourcePack>> defaultPacks = new Lazy<Supplier<Collection>>(SpriteHandler::getDefaultPacks);
    private static final String MASK_LOCATION = CommonMethods.f("/assets/{}/textures/mask.png", "osv");
    private static final Color[][] MASK = SpriteHandler.loadColors(MASK_LOCATION).orElseThrow(() -> CommonMethods.runEx("Build error: mask path is invalid."));

    public static void generateOverlays() {
        for (OreProperties p : Main.ORE_PROPERTIES) {
            CommonMethods.info("Generating textures for {}.", p.name);
            TextureProperties tex = p.texture;
            SpriteHandler.handleVariants(tex.background, tex.original, tex.overlayPath, tex.threshold);
        }
    }

    private static void handleVariants(String background, String foreground, String output, Optional<Float> threshold) {
        Optional<Color[][]> fgColors = SpriteHandler.loadColors(foreground);
        Optional<Color[][]> bgColors = SpriteHandler.loadColors(background);
        if (!fgColors.isPresent()) {
            CommonMethods.error("Missing fg sprite: {}", foreground);
        }
        if (!bgColors.isPresent()) {
            CommonMethods.error("Missing bg sprite: {}", background);
        }
        fgColors.ifPresent(fg -> bgColors.ifPresent(bg -> {
            PathSet paths = new PathSet(output, "");
            HashSet<FileSpec> files = new HashSet<FileSpec>();
            SpriteHandler.generateOverlays(files, bg, fg, paths, threshold);
            SpriteHandler.handleMcMeta(files, foreground, paths);
            ZipTools.copyToResources(files.toArray(new FileSpec[0])).expect("Error writing to resources.zip.");
        }));
    }

    private static void generateOverlays(Set<FileSpec> files, Color[][] bg, Color[][] fg, PathSet paths, Optional<Float> threshold) {
        Color[][] bgScaled = ImageTools.ensureSizeParity(bg, fg);
        Optional<Color[][]> loadNormal = SpriteHandler.loadColors(paths.normal);
        Optional<Color[][]> loadShaded = SpriteHandler.loadColors(paths.shaded);
        Optional<Color[][]> loadDense = SpriteHandler.loadColors(paths.dense);
        Color[][] normalColors = loadNormal.orElseGet(() -> SpriteHandler.genOverlay(bgScaled, fg, threshold));
        Color[][] normalClone = SpriteHandler.cloneColors(normalColors);
        Color[][] shadedColors = loadShaded.orElseGet(() -> ImageTools.shadeOverlay(normalClone, bgScaled, fg, MASK));
        Color[][] denseColors = loadDense.orElseGet(() -> ImageTools.shiftImage(normalColors));
        if (!ZipTools.rpContains(paths.normal)) {
            files.add(new FileSpec(() -> ImageTools.getStream(normalColors), paths.normal));
        }
        if (!ZipTools.rpContains(paths.shaded)) {
            files.add(new FileSpec(() -> ImageTools.getStream(shadedColors), paths.shaded));
        }
        if (!ZipTools.rpContains(paths.dense)) {
            files.add(new FileSpec(() -> ImageTools.getStream(denseColors), paths.dense));
        }
    }

    private static Color[][] genOverlay(Color[][] bg, Color[][] fg, Optional<Float> threshold) {
        return threshold.map(t -> ImageTools.getOverlayManual(bg, fg, t.floatValue())).orElse(ImageTools.getOverlay(bg, fg));
    }

    private static Optional<BufferedImage> loadImage(String path) {
        Optional<InputStream> is = SpriteHandler.locateResource(path);
        if (is.isPresent()) {
            return Result.of(() -> ImageIO.read((InputStream)is.get())).get(Result::IGNORE);
        }
        return CommonMethods.empty();
    }

    private static Optional<InputStream> locateResource(String path) {
        if (Cfg.BlocksCat.overlaysFromRP) {
            ResourceLocation asRL = PathTools.getResourceLocation(path);
            Iterator<IResourcePack> enabled = SpriteHandler.getEnabledPacks().descendingIterator();
            while (enabled.hasNext()) {
                IResourcePack rp = enabled.next();
                try {
                    if (!rp.func_110589_b(asRL)) continue;
                    return CommonMethods.full(rp.func_110590_a(asRL));
                }
                catch (IOException iOException) {
                }
            }
        }
        return SafeFileIO.getResource(path);
    }

    private static boolean resourceExists(String path) {
        Optional<InputStream> resource = SpriteHandler.locateResource(path);
        resource.ifPresent(is -> {
            try {
                is.close();
            }
            catch (IOException e) {
                throw CommonMethods.runEx("Unable to close temporary resource", e);
            }
        });
        return resource.isPresent();
    }

    private static Optional<Color[][]> loadColors(String path) {
        return SpriteHandler.loadImage(path).map(ImageTools::getColors);
    }

    private static Color[][] cloneColors(Color[][] colors) {
        int w = colors.length;
        int h = colors[0].length;
        Color[][] newColors = new Color[w][h];
        for (int x = 0; x < w; ++x) {
            System.arraycopy(colors[x], 0, newColors[x], 0, h);
        }
        return newColors;
    }

    private static void handleMcMeta(Set<FileSpec> files, String forImage, PathSet paths) {
        String metaPath = forImage + ".mcmeta";
        if (SpriteHandler.resourceExists(metaPath)) {
            for (String path : paths) {
                Supplier<InputStream> getter = () -> SpriteHandler.locateResource(metaPath).orElseThrow(() -> CommonMethods.runExF("Resource deleted: {}", metaPath));
                files.add(new FileSpec(getter, path + ".mcmeta"));
            }
        }
    }

    private static Collection<IResourcePack> getDefaultPacks() {
        return (Collection)ReflectionTools.getValue(Minecraft.class, "defaultResourcePacks", "field_110449_ao", Minecraft.func_71410_x());
    }

    private static LinkedList<IResourcePack> getEnabledPacks() {
        return Minecraft.func_71410_x().func_110438_M().func_110613_c().stream().map(ResourcePackRepository.Entry::func_110514_c).collect(Collectors.toCollection(Lists::newLinkedList));
    }
}

