/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.personthecat.orestonevariants.util.CommonMethods;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ExtendedResourceLocation
extends ResourceLocation {
    private final int meta;

    public ExtendedResourceLocation(String name, int meta) {
        super(name);
        this.meta = meta;
    }

    public static ExtendedResourceLocation complete(String name) {
        String[] split = name.split(":");
        if (split.length <= 0 || split.length >= 4) {
            throw CommonMethods.runExF("Syntax error: could not determine blockstate from {}", name);
        }
        String end = split[split.length - 1];
        if (StringUtils.isNumeric((CharSequence)end)) {
            int meta = Integer.parseInt(end);
            String updated = name.replace(":" + end, "");
            return new ExtendedResourceLocation(updated, meta);
        }
        return new ExtendedResourceLocation(name, 0);
    }

    public static ExtendedResourceLocation fromState(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        String name = CommonMethods.nullable(state.func_177230_c().getRegistryName()).orElseThrow(() -> CommonMethods.runEx("Invalid block state registry.")).toString();
        return new ExtendedResourceLocation(name, meta);
    }

    public static ExtendedResourceLocation fromStack(ItemStack stack) {
        int meta = stack.func_77960_j();
        String name = CommonMethods.nullable(stack.func_77973_b().getRegistryName()).orElseThrow(() -> CommonMethods.runEx("Invalid item stack registry.")).toString();
        return new ExtendedResourceLocation(name, meta);
    }

    public ResourceLocation strip() {
        return new ResourceLocation(this.field_110626_a, this.field_110625_b);
    }

    public int getMeta() {
        return this.meta;
    }

    public String toString() {
        String main = super.toString();
        return this.meta > 0 ? main + ":" + this.meta : main;
    }
}

