/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

public class HashGenerator {
    private static final int X_MULTIPLE = 1619;
    private static final int Y_MULTIPLE = 31337;
    private static final int Z_MULTIPLE = 6971;
    private static final long GENERAL_MULTIPLE = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static final long SCALE = 100000000000000000L;
    private final long seed;

    public HashGenerator(long seed) {
        this.seed = HashGenerator.scramble(seed);
    }

    private static long scramble(long seed) {
        long newseed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        return newseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
    }

    public double getHash(int x, int y, int z) {
        long hash = this.seed;
        hash ^= (long)(x * 1619);
        hash ^= (long)(y * 31337);
        hash ^= (long)(z * 6971);
        hash *= hash;
        return (double)(hash >> 13 ^ hash) / 1.0E17;
    }
}

