/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

public class InvertableSet<T>
implements Set<T> {
    private boolean blacklist = false;
    private final Set<T> set;

    public InvertableSet(Set<T> set) {
        this.set = set;
    }

    public static <T> InvertableSet<T> wrap(Set<T> set) {
        return new InvertableSet<T>(set);
    }

    public InvertableSet<T> setBlacklist(boolean b) {
        this.blacklist = b;
        return this;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public InvertableSet<T> setWhitelist(boolean b) {
        this.blacklist = !b;
        return this;
    }

    public boolean isWhitelist() {
        return !this.blacklist;
    }

    public void iterate(T[] a, Consumer<T> f) {
        this.iterate(Arrays.asList(a), f);
    }

    public void iterate(Collection<T> c, Consumer<T> f) {
        if (this.blacklist) {
            HashSet<T> copy = new HashSet<T>(c);
            this.set.forEach(copy::remove);
            copy.forEach(f);
        } else {
            this.set.forEach(f);
        }
    }

    public boolean check(Object o) {
        return this.blacklist != this.set.contains(o);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.set.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }
}

