/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import net.minecraft.util.ResourceLocation;

public class PathTools {
    public static ResourceLocation getResourceLocation(String path) {
        String namespace = PathTools.getNamespaceFromPath(path);
        String result = path.replaceAll("assets[/\\\\]", "").replaceAll(namespace + "[/\\\\]", "").replaceAll("^[/\\\\]", "");
        return new ResourceLocation(namespace, result);
    }

    private static String getNamespaceFromPath(String path) {
        boolean rootFound = false;
        for (String s : path.split("[/\\\\]")) {
            if (rootFound && !s.isEmpty()) {
                return s;
            }
            rootFound |= "assets".equals(s);
        }
        return path;
    }

    public static String ensureNormal(String path) {
        return path.replaceAll("_shaded|dense_", "");
    }

    public static String ensureDense(String path) {
        path = PathTools.ensureNormal(path);
        String name = PathTools.filename(path);
        return path.replace(name, "dense_" + name);
    }

    public static ResourceLocation ensureDense(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), PathTools.ensureDense(location.func_110623_a()));
    }

    public static String ensureShaded(String path) {
        path = PathTools.ensureNormal(path);
        String name = PathTools.filename(path);
        String noExt = PathTools.removeExtension(name);
        return path.replace(noExt, noExt + "_shaded");
    }

    public static String filename(String path) {
        String[] split = path.split("[/\\\\]");
        return split[split.length - 1];
    }

    private static String removeExtension(String s) {
        int extIndex = s.indexOf(".");
        if (extIndex < 0) {
            return s;
        }
        return s.substring(0, extIndex);
    }
}

