/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Iterator;
import java.util.Random;

public class Range
implements Iterable<Integer> {
    public final int min;
    public final int max;

    public Range(int a, int b) {
        if (b > a) {
            this.min = a;
            this.max = b;
        } else {
            this.min = b;
            this.max = a;
        }
    }

    public Range(int max) {
        this(0, max);
    }

    public static Range of(int a, int b) {
        return new Range(a, b);
    }

    public static Range of(int max) {
        return new Range(max);
    }

    public int rand(Random rand) {
        return CommonMethods.numBetween(rand, this.min, this.max);
    }

    public int rand() {
        return CommonMethods.numBetween(new Random(), this.min, this.max);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int i;
            {
                this.i = Range.this.min;
            }

            @Override
            public boolean hasNext() {
                return this.i < Range.this.max;
            }

            @Override
            public Integer next() {
                return this.i++;
            }
        };
    }

    public String toString() {
        return CommonMethods.f("Range[{}-{}]", this.min, this.max);
    }
}

