/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Optional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;

public class ValueLookup {
    private static final BiMap<String, Material> MATERIAL_MAP = ImmutableBiMap.builder().put((Object)"AIR", (Object)Material.field_151579_a).put((Object)"GRASS", (Object)Material.field_151577_b).put((Object)"GROUND", (Object)Material.field_151578_c).put((Object)"WOOD", (Object)Material.field_151575_d).put((Object)"ROCK", (Object)Material.field_151576_e).put((Object)"IRON", (Object)Material.field_151573_f).put((Object)"ANVIL", (Object)Material.field_151574_g).put((Object)"WATER", (Object)Material.field_151586_h).put((Object)"LAVA", (Object)Material.field_151587_i).put((Object)"LEAVES", (Object)Material.field_151584_j).put((Object)"PLANTS", (Object)Material.field_151585_k).put((Object)"VINE", (Object)Material.field_151582_l).put((Object)"SPONGE", (Object)Material.field_151583_m).put((Object)"CLOTH", (Object)Material.field_151580_n).put((Object)"SAND", (Object)Material.field_151595_p).put((Object)"CARPET", (Object)Material.field_151593_r).put((Object)"GLASS", (Object)Material.field_151592_s).put((Object)"REDSTONE_LIGHT", (Object)Material.field_151591_t).put((Object)"TNT", (Object)Material.field_151590_u).put((Object)"CORAL", (Object)Material.field_151589_v).put((Object)"ICE", (Object)Material.field_151588_w).put((Object)"PACKED_ICE", (Object)Material.field_151598_x).put((Object)"SNOW", (Object)Material.field_151597_y).put((Object)"CRAFTED_SNOW", (Object)Material.field_151596_z).put((Object)"CACTUS", (Object)Material.field_151570_A).put((Object)"CLAY", (Object)Material.field_151571_B).put((Object)"GOURD", (Object)Material.field_151572_C).put((Object)"DRAGON_EGG", (Object)Material.field_151566_D).put((Object)"PORTAL", (Object)Material.field_151567_E).put((Object)"CAKE", (Object)Material.field_151568_F).put((Object)"WEB", (Object)Material.field_151569_G).put((Object)"PISTON", (Object)Material.field_76233_E).put((Object)"BARRIER", (Object)Material.field_175972_I).build();
    private static final BiMap<String, MapColor> COLOR_MAP = ImmutableBiMap.builder().put((Object)"AIR", (Object)MapColor.field_151660_b).put((Object)"GRASS", (Object)MapColor.field_151661_c).put((Object)"SAND", (Object)MapColor.field_151658_d).put((Object)"CLOTH", (Object)MapColor.field_151659_e).put((Object)"TNT", (Object)MapColor.field_151656_f).put((Object)"ICE", (Object)MapColor.field_151657_g).put((Object)"IRON", (Object)MapColor.field_151668_h).put((Object)"FOLIAGE", (Object)MapColor.field_151669_i).put((Object)"SNOW", (Object)MapColor.field_151666_j).put((Object)"CLAY", (Object)MapColor.field_151667_k).put((Object)"DIRT", (Object)MapColor.field_151664_l).put((Object)"STONE", (Object)MapColor.field_151665_m).put((Object)"WATER", (Object)MapColor.field_151662_n).put((Object)"WOOD", (Object)MapColor.field_151663_o).put((Object)"QUARTZ", (Object)MapColor.field_151677_p).put((Object)"ADOBE", (Object)MapColor.field_151676_q).put((Object)"MAGENTA", (Object)MapColor.field_151675_r).put((Object)"LIGHT_BLUE", (Object)MapColor.field_151674_s).put((Object)"YELLOW", (Object)MapColor.field_151673_t).put((Object)"LIME", (Object)MapColor.field_151672_u).put((Object)"PINK", (Object)MapColor.field_151671_v).put((Object)"GRAY", (Object)MapColor.field_151670_w).put((Object)"SILVER", (Object)MapColor.field_151680_x).put((Object)"CYAN", (Object)MapColor.field_151679_y).put((Object)"PURPLE", (Object)MapColor.field_151678_z).put((Object)"BLUE", (Object)MapColor.field_151649_A).put((Object)"BROWN", (Object)MapColor.field_151650_B).put((Object)"GREEN", (Object)MapColor.field_151651_C).put((Object)"RED", (Object)MapColor.field_151645_D).put((Object)"BLACK", (Object)MapColor.field_151646_E).put((Object)"GOLD", (Object)MapColor.field_151647_F).put((Object)"DIAMOND", (Object)MapColor.field_151648_G).put((Object)"LAPIS", (Object)MapColor.field_151652_H).put((Object)"EMERALD", (Object)MapColor.field_151653_I).put((Object)"OBSIDIAN", (Object)MapColor.field_151654_J).put((Object)"NETHERRACK", (Object)MapColor.field_151655_K).put((Object)"WHITE_STAINED_HARDENED_CLAY", (Object)MapColor.field_193561_M).put((Object)"ORANGE_STAINED_HARDENED_CLAY", (Object)MapColor.field_193562_N).put((Object)"MAGENTA_STAINED_HARDENED_CLAY", (Object)MapColor.field_193563_O).put((Object)"LIGHT_BLUE_STAINED_HARDENED_CLAY", (Object)MapColor.field_193564_P).put((Object)"YELLOW_STAINED_HARDENED_CLAY", (Object)MapColor.field_193565_Q).put((Object)"LIME_STAINED_HARDENED_CLAY", (Object)MapColor.field_193566_R).put((Object)"PINK_STAINED_HARDENED_CLAY", (Object)MapColor.field_193567_S).put((Object)"GRAY_STAINED_HARDENED_CLAY", (Object)MapColor.field_193568_T).put((Object)"SILVER_STAINED_HARDENED_CLAY", (Object)MapColor.field_193569_U).put((Object)"CYAN_STAINED_HARDENED_CLAY", (Object)MapColor.field_193570_V).put((Object)"PURPLE_STAINED_HARDENED_CLAY", (Object)MapColor.field_193571_W).put((Object)"BLUE_STAINED_HARDENED_CLAY", (Object)MapColor.field_193572_X).put((Object)"BROWN_STAINED_HARDENED_CLAY", (Object)MapColor.field_193573_Y).put((Object)"GREEN_STAINED_HARDENED_CLAY", (Object)MapColor.field_193574_Z).put((Object)"RED_STAINED_HARDENED_CLAY", (Object)MapColor.field_193559_aa).put((Object)"BLACK_STAINED_HARDENED_CLAY", (Object)MapColor.field_193560_ab).build();
    private static final BiMap<String, SoundType> SOUND_MAP = ImmutableBiMap.builder().put((Object)"WOOD", (Object)SoundType.field_185848_a).put((Object)"GROUND", (Object)SoundType.field_185849_b).put((Object)"PLANT", (Object)SoundType.field_185850_c).put((Object)"STONE", (Object)SoundType.field_185851_d).put((Object)"METAL", (Object)SoundType.field_185852_e).put((Object)"GLASS", (Object)SoundType.field_185853_f).put((Object)"CLOTH", (Object)SoundType.field_185854_g).put((Object)"SAND", (Object)SoundType.field_185855_h).put((Object)"SNOW", (Object)SoundType.field_185856_i).put((Object)"LADDER", (Object)SoundType.field_185857_j).put((Object)"ANVIL", (Object)SoundType.field_185858_k).put((Object)"SLIME", (Object)SoundType.field_185859_l).build();

    public static Optional<Material> getMaterial(String key) {
        return CommonMethods.nullable((Material)MATERIAL_MAP.get((Object)key.toUpperCase()));
    }

    public static Optional<MapColor> getMapColor(String key) {
        return CommonMethods.nullable((MapColor)COLOR_MAP.get((Object)key.toUpperCase()));
    }

    public static Optional<SoundType> getSoundType(String key) {
        return CommonMethods.nullable((SoundType)SOUND_MAP.get((Object)key.toUpperCase()));
    }

    public static Optional<String> serialize(Material value) {
        return CommonMethods.nullable((String)MATERIAL_MAP.inverse().get((Object)value));
    }

    public static Optional<String> serialize(MapColor value) {
        return CommonMethods.nullable((String)COLOR_MAP.inverse().get((Object)value));
    }

    public static Optional<String> serialize(SoundType value) {
        return CommonMethods.nullable((String)SOUND_MAP.inverse().get((Object)value));
    }
}

