/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.world;

import com.google.common.collect.ImmutableMap;
import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.StoneProperties;
import com.personthecat.orestonevariants.properties.WorldGenProperties;
import com.personthecat.orestonevariants.util.DualMap;
import com.personthecat.orestonevariants.util.Range;
import com.personthecat.orestonevariants.world.RandomChunkSelector;
import com.personthecat.orestonevariants.world.VariantFeature;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class OreGen
implements IWorldGenerator {
    private final DualMap<Integer, Biome, List<GeneratorData>> worldGenData = this.generateData();
    private final Long2ObjectMap<RandomChunkSelector> selectors = new Long2ObjectOpenHashMap();

    private DualMap<Integer, Biome, List<GeneratorData>> generateData() {
        ArrayList<GeneratorData> list = new ArrayList<GeneratorData>();
        if (Cfg.WorldCat.enableOSVStone) {
            OreGen.getStoneGen(list);
        }
        if (Cfg.WorldCat.enableOSVOres) {
            OreGen.getOreGen(list);
        }
        return OreGen.buildFeatureMap(list);
    }

    private static void getOreGen(List<GeneratorData> list) {
        for (OreProperties ore : Main.ORE_PROPERTIES) {
            for (WorldGenProperties cfg : ore.gen) {
                Map<IBlockState, IBlockState> genMap = OreGen.getGenMap(ore);
                VariantFeature feature = new VariantFeature(genMap, cfg.size);
                list.add(new GeneratorData(cfg, feature));
            }
        }
    }

    private static void getStoneGen(List<GeneratorData> list) {
        for (StoneProperties stone : Main.STONE_PROPERTIES) {
            for (WorldGenProperties cfg : stone.gen) {
                WorldGenMinable feature = new WorldGenMinable(stone.stone.get(), cfg.size);
                list.add(new GeneratorData(cfg, (WorldGenerator)feature));
            }
        }
    }

    private static Map<IBlockState, IBlockState> getGenMap(OreProperties ore) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (BaseOreVariant block : Main.BLOCKS) {
            if (!block.properties.equals(ore)) continue;
            map.put((Object)block.bgBlock, (Object)block.func_176223_P());
        }
        return map.build();
    }

    private static DualMap<Integer, Biome, List<GeneratorData>> buildFeatureMap(List<GeneratorData> master) {
        DualMap.Builder map = new DualMap.Builder();
        for (GeneratorData data : master) {
            ((GeneratorData)data).cfg.dimensions.iterate((Integer[])DimensionManager.getStaticDimensionIDs(), d -> ((GeneratorData)data).cfg.biomes.get().iterate(ForgeRegistries.BIOMES.getValuesCollection(), b -> OreGen.add(map, d, b, data)));
        }
        return map.build();
    }

    public void generate(Random rand, int x, int z, World world, IChunkGenerator chunkGen, IChunkProvider provider) {
        int blockX = x << 4;
        int blockZ = z << 4;
        BlockPos pos = new BlockPos(blockX, 0, blockZ);
        int dim = world.field_73011_w.getDimension();
        Biome b = world.getBiomeForCoordsBody(pos);
        for (GeneratorData gen : this.getData(dim, b)) {
            WorldGenerator feature = gen.feature;
            WorldGenProperties cfg = gen.cfg;
            double chance = this.getChance(world, feature, cfg.ID.get(), x, z, cfg.chance);
            OreGen.run(feature, world, rand, chance, cfg.count, blockX, blockZ, cfg.height);
        }
    }

    private List<GeneratorData> getData(int dim, Biome b) {
        int dimWildcard = WorldGenProperties.DIM_WILDCARD;
        Biome biomeWildcard = WorldGenProperties.BIOME_WILDCARD;
        ArrayList<GeneratorData> data = new ArrayList<GeneratorData>();
        this.addIfPresent(data, dim, b);
        this.addIfPresent(data, dimWildcard, b);
        this.addIfPresent(data, dim, biomeWildcard);
        this.addIfPresent(data, dimWildcard, biomeWildcard);
        return data;
    }

    private void addIfPresent(List<GeneratorData> data, int dim, Biome b) {
        List<GeneratorData> fromMap = this.worldGenData.get(dim, b);
        if (fromMap != null) {
            data.addAll(fromMap);
        }
    }

    private double getChance(World world, WorldGenerator feature, int ID, int x, int z, double baseline) {
        if (world != null && feature instanceof VariantFeature && Cfg.WorldCat.largeClusters) {
            return this.getSelector(world).getProbability(ID, x, z);
        }
        return baseline;
    }

    private RandomChunkSelector getSelector(World world) {
        long seed = world.func_72905_C();
        RandomChunkSelector fromMap = (RandomChunkSelector)this.selectors.get(seed);
        if (fromMap != null) {
            return fromMap;
        }
        RandomChunkSelector selector = new RandomChunkSelector(seed);
        this.selectors.put(seed, (Object)selector);
        return selector;
    }

    private static void run(WorldGenerator gen, World world, Random rand, double chance, int count, int x, int z, Range height) {
        for (int i = 0; i < count; ++i) {
            if (chance != 1.0 && !(rand.nextDouble() <= chance)) continue;
            int y = height.rand(rand);
            int newX = x + rand.nextInt(16);
            int newZ = z + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(newX, y, newZ));
        }
    }

    private static void add(DualMap.Builder<Integer, Biome, List<GeneratorData>> map, int dim, Biome b, GeneratorData data) {
        if (!map.has(dim, b)) {
            map.put(dim, b, new ArrayList());
        }
        map.get(dim, b).add(data);
    }

    private static class GeneratorData {
        private final WorldGenProperties cfg;
        private final WorldGenerator feature;

        private GeneratorData(WorldGenProperties cfg, WorldGenerator feature) {
            this.cfg = cfg;
            this.feature = feature;
        }
    }
}

