/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.hjson.CommentType;
import org.hjson.HjsonDsf;
import org.hjson.HjsonOptions;
import org.hjson.IHjsonDsfProvider;
import org.hjson.JsonArray;
import org.hjson.JsonLiteral;
import org.hjson.JsonNumber;
import org.hjson.JsonObject;
import org.hjson.JsonString;
import org.hjson.JsonValue;
import org.hjson.ParseException;

class HjsonParser {
    private static final int MIN_BUFFER_SIZE = 10;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final String buffer;
    private Reader reader;
    private int index;
    private int line;
    private int lineOffset;
    private int current;
    private StringBuilder captureBuffer;
    private StringBuilder peek;
    private boolean capture;
    private boolean legacyRoot;
    private IHjsonDsfProvider[] dsfProviders;

    HjsonParser(String string, HjsonOptions options) {
        this.buffer = string;
        this.reset();
        if (options != null) {
            this.dsfProviders = options.getDsfProviders();
            this.legacyRoot = options.getParseLegacyRoot();
        } else {
            this.dsfProviders = new IHjsonDsfProvider[0];
            this.legacyRoot = true;
        }
    }

    HjsonParser(Reader reader, HjsonOptions options) throws IOException {
        this(HjsonParser.readToEnd(reader), options);
    }

    static String readToEnd(Reader reader) throws IOException {
        int n;
        char[] part = new char[8192];
        StringBuilder sb = new StringBuilder();
        while ((n = reader.read(part, 0, part.length)) != -1) {
            sb.append(part, 0, n);
        }
        return sb.toString();
    }

    void reset() {
        this.current = 0;
        this.lineOffset = 0;
        this.index = 0;
        this.line = 1;
        this.peek = new StringBuilder();
        this.reader = new StringReader(this.buffer + ' ');
        this.capture = false;
        this.captureBuffer = null;
    }

    JsonValue parse() throws IOException {
        this.read();
        String header = this.readBetweenVals();
        JsonValue value = this.tryParse();
        value.setFullComment(CommentType.BOL, header);
        return value;
    }

    JsonValue tryParse() throws IOException {
        if (this.legacyRoot) {
            switch (this.current) {
                case 91: 
                case 123: {
                    return this.checkTrailing(this.readValue());
                }
            }
            try {
                return this.checkTrailing(this.readObject(false));
            }
            catch (Exception exception) {
                this.reset();
                this.read();
                this.readBetweenVals();
                try {
                    return this.checkTrailing(this.readValue());
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
        }
        return this.checkTrailing(this.readValue());
    }

    JsonValue checkTrailing(JsonValue v) throws ParseException, IOException {
        v.setFullComment(CommentType.EOL, this.readBetweenVals());
        if (!this.isEndOfText()) {
            throw this.error("Extra characters in input: " + this.current);
        }
        return v;
    }

    private JsonValue readValue() throws IOException {
        switch (this.current) {
            case 34: 
            case 39: {
                return this.readString();
            }
            case 91: {
                return this.readArray();
            }
            case 123: {
                return this.readObject(true);
            }
        }
        return this.readTfnns();
    }

    private JsonValue readTfnns() throws IOException {
        StringBuilder value = new StringBuilder();
        int first = this.current;
        if (JsonValue.isPunctuatorChar(first)) {
            throw this.error("Found a punctuator character '" + (char)first + "' when expecting a quoteless string (check your syntax)");
        }
        value.append((char)this.current);
        while (true) {
            boolean isEol;
            this.read();
            boolean bl = isEol = this.current < 0 || this.current == 13 || this.current == 10;
            if (isEol || this.current == 44 || this.current == 125 || this.current == 93 || this.current == 35 || this.current == 47 && (this.peek() == 47 || this.peek() == 42)) {
                switch (first) {
                    case 102: 
                    case 110: 
                    case 116: {
                        String svalue = value.toString().trim();
                        if (svalue.equals("false")) {
                            return JsonLiteral.jsonFalse();
                        }
                        if (svalue.equals("null")) {
                            return JsonLiteral.jsonNull();
                        }
                        if (!svalue.equals("true")) break;
                        return JsonLiteral.jsonTrue();
                    }
                    default: {
                        JsonValue n;
                        if (first != 45 && (first < 48 || first > 57) || (n = HjsonParser.tryParseNumber(value, false)) == null) break;
                        return n;
                    }
                }
                if (isEol) {
                    return HjsonDsf.parse(this.dsfProviders, value.toString().trim());
                }
            }
            value.append((char)this.current);
        }
    }

    private JsonObject readObject(boolean expectCloser) throws IOException {
        String bol;
        if (expectCloser) {
            this.read();
        }
        JsonObject object = new JsonObject();
        boolean compact = this.isContainerCompact(expectCloser);
        ContainerData data = new ContainerData(compact);
        while (true) {
            bol = this.readBetweenVals();
            if (this.checkEndOfContainer("object", '}', expectCloser)) break;
            String name = this.readName();
            this.readBetweenVals();
            if (!this.readIf(':')) {
                throw this.expected("':'");
            }
            this.readBetweenVals();
            JsonValue value = this.readValue();
            this.finishContainerElement(data, value);
            value.setFullComment(CommentType.BOL, bol);
            object.add(name, value);
        }
        object.setFullComment(CommentType.INTERIOR, bol);
        return data.into(object);
    }

    private JsonArray readArray() throws IOException {
        String bol;
        this.read();
        JsonArray array = new JsonArray();
        boolean compact = this.isContainerCompact(true);
        ContainerData data = new ContainerData(compact);
        while (true) {
            bol = this.readBetweenVals();
            if (this.checkEndOfContainer("array", ']', true)) break;
            JsonValue value = this.readValue();
            value.setFullComment(CommentType.BOL, bol);
            this.finishContainerElement(data, value);
            array.add(value);
        }
        array.setFullComment(CommentType.INTERIOR, bol);
        return data.into(array);
    }

    private void finishContainerElement(ContainerData data, JsonValue value) throws IOException {
        int delimiter;
        int numCommas = 0;
        while ((delimiter = this.readNextDelimiter()) == 44) {
            this.skipToNL();
            ++numCommas;
        }
        if (delimiter == 10) {
            data.nl();
            while ((delimiter = this.readNextDelimiter()) > 0) {
                if (delimiter != 44) continue;
                data.overrideCondensed();
                ++numCommas;
            }
        } else {
            String eol = this.readBetweenVals(true);
            if (!eol.isEmpty()) {
                value.setFullComment(CommentType.EOL, eol);
            } else {
                data.incrLineLength();
            }
        }
        if (numCommas > 1) {
            throw this.error("Extra comma detected. Unclear element");
        }
    }

    private boolean checkEndOfContainer(String type, char closer, boolean expectCloser) throws IOException {
        if (this.isEndOfText()) {
            if (expectCloser) {
                throw this.error("End of input while parsing an " + type + ". Did you forget a closing'" + closer + "'?");
            }
            return true;
        }
        if (expectCloser) {
            return this.readIf(closer);
        }
        return false;
    }

    private int readNextDelimiter() throws IOException {
        this.skipToNL();
        int delimiter = this.current;
        if (delimiter == 10 || delimiter == 44) {
            this.read();
            return delimiter;
        }
        return -1;
    }

    private boolean isContainerCompact(boolean expectCloser) throws IOException {
        this.skipToNL();
        this.readIf('\r');
        return this.current != 10 && expectCloser;
    }

    private String readName() throws IOException {
        if (this.current == 34 || this.current == 39) {
            return this.readStringInternal(false);
        }
        StringBuilder name = new StringBuilder();
        int space = -1;
        int start = this.index;
        while (true) {
            if (this.current == 58) {
                if (name.length() == 0) {
                    throw this.error("Found ':' but no key name (for an empty key name use quotes)");
                }
                if (space >= 0 && space != name.length()) {
                    this.index = start + space;
                    throw this.error("Found whitespace in your key name (use quotes to include)");
                }
                return name.toString();
            }
            if (HjsonParser.isWhiteSpace(this.current)) {
                if (space < 0) {
                    space = name.length();
                }
            } else {
                if (this.current < 32) {
                    throw this.error("Name is not closed");
                }
                if (JsonValue.isPunctuatorChar(this.current)) {
                    throw this.error("Found '" + (char)this.current + "' where a key name was expected (check your syntax or use quotes if the key name includes {}[],: or whitespace)");
                }
                name.append((char)this.current);
            }
            this.read();
        }
    }

    private String readMlString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int triple = 0;
        int indent = this.index - this.lineOffset - 4;
        while (HjsonParser.isWhiteSpace(this.current) && this.current != 10) {
            this.read();
        }
        if (this.current == 10) {
            this.read();
            this.skipIndent(indent);
        }
        while (true) {
            if (this.current < 0) {
                throw this.error("Bad multiline string");
            }
            if (this.current == 39) {
                this.read();
                if (++triple != 3) continue;
                if (sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                return sb.toString();
            }
            while (triple > 0) {
                sb.append('\'');
                --triple;
            }
            if (this.current == 10) {
                sb.append('\n');
                this.read();
                this.skipIndent(indent);
                continue;
            }
            if (this.current != 13) {
                sb.append((char)this.current);
            }
            this.read();
        }
    }

    private void skipIndent(int indent) throws IOException {
        while (indent-- > 0 && HjsonParser.isWhiteSpace(this.current) && this.current != 10) {
            this.read();
        }
    }

    private JsonValue readString() throws IOException {
        return new JsonString(this.readStringInternal(true));
    }

    private String readStringInternal(boolean allowML) throws IOException {
        int exitCh = this.current;
        this.read();
        this.startCapture();
        while (this.current != exitCh) {
            if (this.current == 92) {
                this.readEscape();
                continue;
            }
            if (this.current < 32) {
                throw this.expected("valid string character");
            }
            this.read();
        }
        String string = this.endCapture();
        this.read();
        if (allowML && exitCh == 39 && this.current == 39 && string.length() == 0) {
            this.read();
            return this.readMlString();
        }
        return string;
    }

    private void readEscape() throws IOException {
        this.pauseCapture();
        this.read();
        switch (this.current) {
            case 34: 
            case 39: 
            case 47: 
            case 92: {
                this.captureBuffer.append((char)this.current);
                break;
            }
            case 98: {
                this.captureBuffer.append('\b');
                break;
            }
            case 102: {
                this.captureBuffer.append('\f');
                break;
            }
            case 110: {
                this.captureBuffer.append('\n');
                break;
            }
            case 114: {
                this.captureBuffer.append('\r');
                break;
            }
            case 116: {
                this.captureBuffer.append('\t');
                break;
            }
            case 117: {
                char[] hexChars = new char[4];
                for (int i = 0; i < 4; ++i) {
                    this.read();
                    if (!this.isHexDigit()) {
                        throw this.expected("hexadecimal digit");
                    }
                    hexChars[i] = (char)this.current;
                }
                this.captureBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                break;
            }
            default: {
                throw this.expected("valid escape sequence");
            }
        }
        this.capture = true;
        this.read();
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static JsonValue tryParseNumber(StringBuilder value, boolean stopAtNext) throws IOException {
        char ch;
        char first;
        int idx = 0;
        int len = value.length();
        if (idx < len && value.charAt(idx) == '-') {
            ++idx;
        }
        if (idx >= len) {
            return null;
        }
        if (!HjsonParser.isDigit(first = value.charAt(idx++))) {
            return null;
        }
        if (first == '0' && idx < len && HjsonParser.isDigit(value.charAt(idx))) {
            return null;
        }
        while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
            ++idx;
        }
        if (idx < len && value.charAt(idx) == '.') {
            if (++idx >= len || !HjsonParser.isDigit(value.charAt(idx++))) {
                return null;
            }
            while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
                ++idx;
            }
        }
        if (idx < len && Character.toLowerCase(value.charAt(idx)) == 'e') {
            if (++idx < len && (value.charAt(idx) == '+' || value.charAt(idx) == '-')) {
                ++idx;
            }
            if (idx >= len || !HjsonParser.isDigit(value.charAt(idx++))) {
                return null;
            }
            while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
                ++idx;
            }
        }
        int last = idx;
        while (idx < len && HjsonParser.isWhiteSpace(value.charAt(idx))) {
            ++idx;
        }
        boolean foundStop = false;
        if (idx < len && stopAtNext && ((ch = value.charAt(idx)) == ',' || ch == '}' || ch == ']' || ch == '#' || ch == '/' && len > idx + 1 && (value.charAt(idx + 1) == '/' || value.charAt(idx + 1) == '*'))) {
            foundStop = true;
        }
        if (idx < len && !foundStop) {
            return null;
        }
        return new JsonNumber(Double.parseDouble(value.substring(0, last)));
    }

    static JsonValue tryParseNumber(String value, boolean stopAtNext) throws IOException {
        return HjsonParser.tryParseNumber(new StringBuilder(value), stopAtNext);
    }

    private boolean readIf(char ch) throws IOException {
        if (this.current != ch) {
            return false;
        }
        this.read();
        return true;
    }

    private String readBetweenVals() throws IOException {
        return this.readBetweenVals(false);
    }

    private String readBetweenVals(boolean toEOL) throws IOException {
        this.startCapture();
        while (!this.isEndOfText()) {
            this.pauseCapture();
            this.skipWhiteSpace();
            this.startCapture();
            if (this.current == 35 || this.current == 47 && this.peek() == 47) {
                do {
                    this.read();
                } while (this.current >= 0 && this.current != 10);
                if (toEOL) break;
                this.read();
                continue;
            }
            if (this.current != 47 || this.peek() != 42) break;
            int commentOffset = this.index - this.lineOffset - 1;
            this.read();
            do {
                this.read();
                if (this.current != 10) continue;
                this.read();
                this.skipIfWhiteSpace(commentOffset);
            } while (this.current >= 0 && (this.current != 42 || this.peek() != 47));
            this.read();
            this.read();
            while (this.current == 13 || this.current == 10) {
                this.read();
            }
        }
        return this.endCapture().trim();
    }

    private int skipWhiteSpace() throws IOException {
        int numSkipped = 0;
        while (this.isWhiteSpace()) {
            this.read();
            ++numSkipped;
        }
        return numSkipped;
    }

    private void skipToNL() throws IOException {
        while (this.current == 32 || this.current == 9 || this.current == 13) {
            this.read();
        }
    }

    private int peek(int idx) throws IOException {
        while (idx >= this.peek.length()) {
            int c = this.reader.read();
            if (c < 0) {
                return c;
            }
            this.peek.append((char)c);
        }
        return this.peek.charAt(idx);
    }

    private int peek() throws IOException {
        return this.peek(0);
    }

    private boolean read() throws IOException {
        if (this.current == 10) {
            ++this.line;
            this.lineOffset = this.index;
        }
        if (this.peek.length() > 0) {
            this.current = this.peek.charAt(0);
            this.peek.deleteCharAt(0);
        } else {
            this.current = this.reader.read();
        }
        if (this.current < 0) {
            return false;
        }
        ++this.index;
        if (this.capture) {
            this.captureBuffer.append((char)this.current);
        }
        return true;
    }

    private void skip(int num) throws IOException {
        this.pauseCapture();
        for (int i = 0; i < num; ++i) {
            this.read();
        }
        this.startCapture();
    }

    private void skipIfWhiteSpace(int num) throws IOException {
        this.pauseCapture();
        for (int i = 0; i < num; ++i) {
            if (!this.isWhiteSpace()) continue;
            this.read();
        }
        this.startCapture();
    }

    private void startCapture() {
        if (this.captureBuffer == null) {
            this.captureBuffer = new StringBuilder();
        }
        this.capture = true;
        this.captureBuffer.append((char)this.current);
    }

    private void pauseCapture() {
        int len = this.captureBuffer.length();
        if (len > 0) {
            this.captureBuffer.deleteCharAt(len - 1);
        }
        this.capture = false;
    }

    private String endCapture() {
        String captured;
        this.pauseCapture();
        if (this.captureBuffer.length() > 0) {
            captured = this.captureBuffer.toString();
            this.captureBuffer.setLength(0);
        } else {
            captured = "";
        }
        this.capture = false;
        return captured;
    }

    private ParseException expected(String expected) {
        if (this.isEndOfText()) {
            return this.error("Unexpected end of input");
        }
        return this.error("Expected " + expected);
    }

    private ParseException error(String message) {
        int column = this.index - this.lineOffset;
        int offset = this.isEndOfText() ? this.index : this.index - 1;
        return new ParseException(message, offset, this.line, column - 1);
    }

    static boolean isWhiteSpace(int ch) {
        return ch == 32 || ch == 9 || ch == 10 || ch == 13;
    }

    private boolean isWhiteSpace() {
        return HjsonParser.isWhiteSpace((char)this.current);
    }

    private boolean isHexDigit() {
        return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
    }

    private boolean isEndOfText() {
        return this.current == -1;
    }

    private static class ContainerData {
        private int lineLength = 1;
        private int sumLineLength = 0;
        private int numLines = 0;
        private boolean condensed;

        private ContainerData(boolean condensed) {
            this.condensed = condensed;
        }

        private void incrLineLength() {
            ++this.lineLength;
        }

        private void overrideCondensed() {
            this.condensed = false;
        }

        private void nl() {
            this.sumLineLength += this.lineLength;
            this.lineLength = 1;
            ++this.numLines;
        }

        private int finalLineLength(int size) {
            return this.sumLineLength > 0 ? this.avgLineLength() : (this.condensed ? size : 1);
        }

        private int avgLineLength() {
            int avgLineLength = this.sumLineLength / this.numLines;
            if (avgLineLength <= 0) {
                avgLineLength = 1;
            }
            return avgLineLength;
        }

        private JsonArray into(JsonArray array) {
            return array.setLineLength(this.finalLineLength(array.size())).setCondensed(this.condensed);
        }

        private JsonObject into(JsonObject object) {
            return object.setLineLength(this.finalLineLength(object.size())).setCondensed(this.condensed);
        }
    }
}

