/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hjson.CommentStyle;
import org.hjson.CommentType;
import org.hjson.JsonType;
import org.hjson.JsonValue;

public class JsonArray
extends JsonValue
implements Iterable<JsonValue> {
    private final List<JsonValue> values;
    private transient boolean condensed;
    private transient int lineLength;

    public JsonArray() {
        this.values = new ArrayList<JsonValue>();
        this.condensed = false;
        this.lineLength = 1;
    }

    public JsonArray(JsonArray array) {
        this(array, false);
    }

    private JsonArray(JsonArray array, boolean unmodifiable) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        this.values = unmodifiable ? Collections.unmodifiableList(array.values) : new ArrayList<JsonValue>(array.values);
        this.condensed = array.condensed;
        this.lineLength = array.lineLength;
    }

    public static JsonArray unmodifiableArray(JsonArray array) {
        return new JsonArray(array, true);
    }

    public List<Object> asRawList() {
        ArrayList<Object> array = new ArrayList<Object>();
        for (JsonValue value : this) {
            array.add(value.asRaw());
        }
        return array;
    }

    public JsonArray add(int value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(int value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(long value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(long value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(float value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(float value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(double value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(double value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(boolean value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(boolean value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(String value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(String value, String comment) {
        this.values.add(JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray add(JsonValue value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.add(value);
        return this;
    }

    public JsonArray add(JsonValue value, String comment) {
        this.values.add(value.setComment(comment));
        return this;
    }

    public JsonArray set(int index, int value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, int value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, long value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, long value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, float value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, float value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, double value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, double value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, boolean value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, boolean value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, String value) {
        this.set(index, JsonArray.valueOf(value));
        return this;
    }

    public JsonArray set(int index, String value, String comment) {
        this.set(index, JsonArray.valueOf(value).setComment(comment));
        return this;
    }

    public JsonArray set(int index, JsonValue value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.set(index, value).setAccessed(true);
        return this;
    }

    public JsonArray set(int index, JsonValue value, String comment) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.set(index, value.setComment(comment));
        return this;
    }

    public JsonArray setComment(int index, String comment) {
        this.get(index).setComment(comment);
        return this;
    }

    public JsonArray setComment(int index, CommentType type, CommentStyle style, String comment) {
        this.get(index).setComment(type, style, comment);
        return this;
    }

    public JsonArray remove(int index) {
        this.values.remove(index);
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JsonValue get(int index) {
        return this.values.get(index).setAccessed(true);
    }

    public List<JsonValue> values() {
        return Collections.unmodifiableList(this.values);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public JsonArray setLineLength(int value) {
        this.lineLength = value;
        return this;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public JsonArray setCondensed(boolean value) {
        this.condensed = value;
        return this;
    }

    public List<String> getUnusedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        int index = 0;
        for (JsonValue v : this) {
            if (v.isObject()) {
                for (String s : v.asObject().getUnusedPaths()) {
                    paths.add("[" + index + "]." + s);
                }
            }
            ++index;
        }
        return paths;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        final Iterator<JsonValue> iterator = this.values.iterator();
        return new Iterator<JsonValue>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public JsonValue next() {
                return (JsonValue)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public JsonType getType() {
        return JsonType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonArray other = (JsonArray)object;
        return this.values.equals(other.values);
    }
}

