/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.hjson.CommentStyle;
import org.hjson.CommentType;
import org.hjson.JsonType;
import org.hjson.JsonValue;

public class JsonObject
extends JsonValue
implements Iterable<Member> {
    private final List<String> names;
    private final List<JsonValue> values;
    private transient HashIndexTable table;
    private transient boolean condensed;
    private transient int lineLength;

    public JsonObject() {
        this.names = new ArrayList<String>();
        this.values = new ArrayList<JsonValue>();
        this.table = new HashIndexTable();
        this.condensed = false;
        this.lineLength = 1;
    }

    public JsonObject(JsonObject object) {
        this(object, false);
    }

    private JsonObject(JsonObject object, boolean unmodifiable) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (unmodifiable) {
            this.names = Collections.unmodifiableList(object.names);
            this.values = Collections.unmodifiableList(object.values);
        } else {
            this.names = new ArrayList<String>(object.names);
            this.values = new ArrayList<JsonValue>(object.values);
        }
        this.table = new HashIndexTable();
        this.condensed = object.condensed;
        this.lineLength = object.lineLength;
        this.updateHashIndex();
    }

    public static JsonObject unmodifiableObject(JsonObject object) {
        return new JsonObject(object, true);
    }

    public boolean has(String name) {
        return this.indexOf(name) != -1;
    }

    public JsonObject add(String name, int value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, int value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, long value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, long value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, float value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, float value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, double value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, double value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, boolean value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, boolean value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, String value) {
        return this.add(name, JsonObject.valueOf(value));
    }

    public JsonObject add(String name, String value, String comment) {
        return this.add(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject add(String name, JsonValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.table.add(name, this.names.size());
        this.names.add(name);
        this.values.add(value);
        return this;
    }

    public JsonObject add(String name, JsonValue value, String comment) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        value.setComment(comment);
        return this.add(name, value);
    }

    public JsonObject set(String name, int value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, int value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, long value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, long value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, float value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, float value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, double value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, double value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, boolean value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, boolean value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, String value) {
        return this.set(name, JsonObject.valueOf(value));
    }

    public JsonObject set(String name, String value, String comment) {
        return this.set(name, JsonObject.valueOf(value).setComment(comment));
    }

    public JsonObject set(String name, JsonValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        value.setAccessed(true);
        int index = this.indexOf(name);
        if (index != -1) {
            this.values.set(index, value);
        } else {
            this.table.add(name, this.names.size());
            this.names.add(name);
            this.values.add(value);
        }
        return this;
    }

    public JsonObject set(String name, JsonValue value, String comment) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        return this.set(name, value.setComment(comment));
    }

    public JsonObject setComment(String name, String comment) {
        this.get(name).setComment(comment);
        return this;
    }

    public JsonObject setComment(String name, CommentType type, CommentStyle style, String comment) {
        this.get(name).setComment(type, style, comment);
        return this;
    }

    public JsonObject remove(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        if (index != -1) {
            this.table.remove(index);
            this.names.remove(index);
            this.values.remove(index);
        }
        return this;
    }

    public JsonValue get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        return index != -1 ? this.values.get(index).setAccessed(true) : null;
    }

    public int getInt(String name, int defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asInt() : defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asLong() : defaultValue;
    }

    public float getFloat(String name, float defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asFloat() : defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asDouble() : defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asBoolean() : defaultValue;
    }

    public String getString(String name, String defaultValue) {
        JsonValue value = this.get(name);
        return value != null ? value.asString() : defaultValue;
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public List<String> names() {
        return Collections.unmodifiableList(this.names);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public JsonObject setLineLength(int value) {
        this.lineLength = value;
        return this;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public JsonObject setCondensed(boolean value) {
        this.condensed = value;
        return this;
    }

    public List<String> getUnusedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (Member m : this) {
            if (!m.value.isAccessed()) {
                paths.add(m.name);
            }
            if (m.value.isObject()) {
                for (String s : m.value.asObject().getUnusedPaths()) {
                    paths.add(m.name + "." + s);
                }
                continue;
            }
            if (!m.value.isArray()) continue;
            for (String s : m.value.asArray().getUnusedPaths()) {
                paths.add(m.name + s);
            }
        }
        return paths;
    }

    public JsonObject sort() {
        ArrayList<Member> members = new ArrayList<Member>();
        for (Member m : this) {
            members.add(m);
        }
        Member[] membersArray = members.toArray(new Member[members.size()]);
        Arrays.sort(membersArray, new MemberComparator());
        this.names.clear();
        this.values.clear();
        for (Member m : membersArray) {
            this.add(m.name, m.value);
        }
        return this;
    }

    @Override
    public Iterator<Member> iterator() {
        final Iterator<String> namesIterator = this.names.iterator();
        final Iterator<JsonValue> valuesIterator = this.values.iterator();
        return new Iterator<Member>(){

            @Override
            public boolean hasNext() {
                return namesIterator.hasNext();
            }

            @Override
            public Member next() {
                String name = (String)namesIterator.next();
                JsonValue value = (JsonValue)valuesIterator.next();
                return new Member(name, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public JsonType getType() {
        return JsonType.OBJECT;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        return this.names.equals(other.names) && this.values.equals(other.values);
    }

    int indexOf(String name) {
        int index = this.table.get(name);
        if (index != -1 && name.equals(this.names.get(index))) {
            return index;
        }
        return this.names.lastIndexOf(name);
    }

    private synchronized void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.table = new HashIndexTable();
        this.updateHashIndex();
    }

    private void updateHashIndex() {
        int size = this.names.size();
        for (int i = 0; i < size; ++i) {
            this.table.add(this.names.get(i), i);
        }
    }

    public static class MemberComparator
    implements Comparator<Member> {
        @Override
        public int compare(Member m1, Member m2) {
            return m1.name.compareToIgnoreCase(m2.name);
        }
    }

    static class HashIndexTable {
        private final byte[] hashTable = new byte[32];

        public HashIndexTable() {
        }

        public HashIndexTable(HashIndexTable original) {
            System.arraycopy(original.hashTable, 0, this.hashTable, 0, this.hashTable.length);
        }

        void add(String name, int index) {
            int slot = this.hashSlotfor(name);
            this.hashTable[slot] = index < 255 ? (byte)(index + 1) : (byte)0;
        }

        void remove(int index) {
            for (int i = 0; i < this.hashTable.length; ++i) {
                if (this.hashTable[i] == index + 1) {
                    this.hashTable[i] = 0;
                    continue;
                }
                if (this.hashTable[i] <= index + 1) continue;
                int n = i;
                this.hashTable[n] = (byte)(this.hashTable[n] - 1);
            }
        }

        int get(Object name) {
            int slot = this.hashSlotfor(name);
            return (this.hashTable[slot] & 0xFF) - 1;
        }

        private int hashSlotfor(Object element) {
            return element.hashCode() & this.hashTable.length - 1;
        }
    }

    public static class Member {
        private final String name;
        private final JsonValue value;

        Member(String name, JsonValue value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public JsonValue getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
    }
}

