/*
 * Decompiled with CFR 0.152.
 */
package com.crankysupertoon.electrostatic;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import slimeknights.tconstruct.library.tools.TinkerToolCore;

public class ElectricToolRegistry {
    private static final List<Predicate<ItemStack>> predicates = Lists.newArrayList((Object[])new Predicate[]{s -> s.func_77973_b() instanceof TinkerToolCore});

    public static void registerPredicate(Predicate<ItemStack> predicate) {
        predicates.add(predicate);
    }

    public static boolean isElectric(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.NORTH) && ElectricToolRegistry.isPotentiallyElectric(stack);
    }

    public static boolean isPotentiallyElectric(ItemStack stack) {
        return predicates.stream().anyMatch(p -> p.test(stack));
    }
}

